﻿using SpamClassifier.Core.Services;
using Xunit;

namespace SpamClassifier.Tests;

public class MailSpamClassifierTests
{
    private readonly MailSpamClassifierService _classifier;

    public MailSpamClassifierTests()
    {
        _classifier = new MailSpamClassifierService();

        var dataPath = Path.Combine(
            AppContext.BaseDirectory,
            "Data",
            "spam_or_not_spam.csv");

        _classifier.Train(dataPath);
    }

    [Fact]
    public void Predict_EmailSpam_ReturnsSpam()
    {
        // Arrange
        var spamText = "You have WON free money! Claim your prize now!";

        // Act
        var result = _classifier.Predict(spamText);

        // Assert
        Assert.True(result.IsSpam);
    }

    [Fact]
    public void Predict_EmailHam_ReturnsNotSpam()
    {
        // Arrange
        var hamText = "Hi, can we reschedule the meeting? I have dentist appointment";

        // Act
        var result = _classifier.Predict(hamText);

        // Assert
        Assert.False(result.IsSpam);
    }
}
