# SpamClassifier (ML.NET)

A simple machine learning project built with **ML.NET** and **.NET 8**, demonstrating text classification  
(spam vs ham) for **emails** and **SMS messages**.

The project includes:
- custom ML.NET training pipelines,
- clean architecture (**Core / ConsoleApp / Tests**),
- interactive console application (can be replaced with ASP.NET, WPF, etc.),
- unit tests using **xUnit**.

Models are trained locally using ML.NET without any external services.

---

## How to Run the Application

### Requirements
- **.NET SDK 8.0** or newer
- **Git**

---

### Clone the repository

```bash
git clone https://github.com/mike-314/SpamClassifier.git
cd SpamClassifier
```

---

### Restore dependencies

```bash
dotnet restore
```

---

### Run the console application

```bash
dotnet run --project SpamClassifier.ConsoleApp
```

---

### Console usage

After starting the application, choose classifier type:

```
1 - Email
2 - SMS
```

After the model has been trained, enter text messages to classify.  
An empty line exits the application.

---

## Running Unit Tests

```bash
dotnet test
```
