﻿using Microsoft.EntityFrameworkCore;
using System.ComponentModel.DataAnnotations;

namespace LinqToSqlite
{
    internal class Program
    {
        static Adres adresMatulewscy = new Adres() { Id = 1, Miasto = "Toruń", Ulica = "Grudziądzka", NumerDomu = 5, NumerMieszkania = 477 };
        static Adres adresKowalscy = new Adres() { Id = 2, Miasto = "Toruń", Ulica = "Balonowa", NumerDomu = 7 };
        static Adres adresHP = new Adres() { Id = 3, Miasto = "Hogward", Ulica = "Pokątna", NumerDomu = 4, NumerMieszkania = 1 };

        static List<Osoba> osoby = new List<Osoba>()
        {
            new Osoba() { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 112332, Wiek  = 53, Adres = adresMatulewscy },
            new Osoba() { Id = 6, Imię = "Bartosz", Nazwisko = "Matulewski", NumerTelefonu = 282323, Wiek  = 20, Adres = adresMatulewscy },
            new Osoba() { Id = 7, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 3123423, Wiek  = 13, Adres = adresMatulewscy },
            new Osoba() { Id = 2, Imię = "Jan", Nazwisko = "Kowalski", NumerTelefonu = 11232342, Wiek  = 15, Adres = adresKowalscy },
            new Osoba() { Id = 3, Imię = "Albert", Nazwisko = "Kowalski", NumerTelefonu = 11232342, Wiek  = 12, Adres = adresKowalscy },
            new Osoba() { Id = 4, Imię = "Harry", Nazwisko = "Potter", NumerTelefonu = 3875345, Wiek  = 30, Adres = adresHP },
            new Osoba() { Id = 5, Imię = "Ron", Nazwisko = "Wesley", NumerTelefonu = 3746323, Wiek  = 30, Adres = adresHP },
            new Osoba() { Id = 8, Imię = "Hermiona", Nazwisko = "Granger", NumerTelefonu = 3534534, Wiek  = 31, Adres = adresHP }
        };

        static void podglądBazyDanych(BazaDanychOsób bdo)
        {
            Console.WriteLine("Osoby:");
            foreach (int id in bdo.IdentyfikatoryOsób)
                Console.WriteLine("\t" + bdo[id].ToString());

#if DEBUG
            Console.WriteLine("Adresy:");
            foreach(Adres adres in bdo.Adresy)
                Console.WriteLine("\t" + adres.ToString());
#endif
        }

        static void Main(string[] args)
        {
            BazaDanychOsób bdo = new BazaDanychOsób();
            podglądBazyDanych(bdo);

            /*
            List<int> użyteIdentyfikatory = new List<int>();
            foreach(Osoba osoba in osoby)
            {
                użyteIdentyfikatory.Add(bdo.DodajOsobę(osoba));
            }
            podglądBazyDanych(bdo);
            */

            //bdo.UsuńOsobę(6);
            //podglądBazyDanych(bdo);

            Console.WriteLine("Press any key");
            Console.ReadKey();
        }
    }
}
