﻿using System.Xml.Linq;

namespace LINQtoObjects
{
    class Osoba : ICloneable //DTO, POCO
    {
        public int Id;
        public string Imię, Nazwisko;
        public int NumerTelefonu;
        public int Wiek;

        public override string ToString()
        {
            return $"{Imię} {Nazwisko} ({Wiek}), nr telefonu: {NumerTelefonu}";
        }

        public object Clone()
        {
            return new Osoba() { Imię = this.Imię, Nazwisko = this.Nazwisko, Wiek = this.Wiek, NumerTelefonu = this.NumerTelefonu };
        }

        public static readonly Osoba OsobaPusta = new Osoba() { Id = -1, Imię = "", Nazwisko = "", NumerTelefonu = -1, Wiek = -1 };
    }

    static class Rozszerzenia
    {
        public static void Wyświetl<T>(this IEnumerable<T> list)
        {
            Console.WriteLine("Lista obiektów: ");
            foreach (T element in list)
            {
                if (element != null) Console.WriteLine(element.ToString());
                else Console.WriteLine("---");
            }
            Console.WriteLine();
        }
    }

    internal class Program
    {
        static List<Osoba> osoby = new List<Osoba>()
        {
            new Osoba() { Id = 1, Imię = "Jacek", Nazwisko = "Matulewski", NumerTelefonu = 112332, Wiek  = 53 },
            new Osoba() { Id = 6, Imię = "Bartosz", Nazwisko = "Matulewski", NumerTelefonu = 282323, Wiek  = 20 },
            new Osoba() { Id = 7, Imię = "Katarzyna", Nazwisko = "Matulewska", NumerTelefonu = 3123423, Wiek  = 13 },
            new Osoba() { Id = 2, Imię = "Jan", Nazwisko = "Kowalski", NumerTelefonu = 11232342, Wiek  = 15 },
            new Osoba() { Id = 3, Imię = "Albert", Nazwisko = "Kowalski", NumerTelefonu = 11232342, Wiek  = 12 },
            new Osoba() { Id = 4, Imię = "Harry", Nazwisko = "Potter", NumerTelefonu = 3875345, Wiek  = 30 },
            new Osoba() { Id = 5, Imię = "Ron", Nazwisko = "Wesley", NumerTelefonu = 3746323, Wiek  = 30 },
            new Osoba() { Id = 8, Imię = "Hermiona", Nazwisko = "Granger", NumerTelefonu = 3534534, Wiek  = 31 }
        };

        static void Main1(string[] args)
        {
            osoby.Wyświetl();

            var listaOsóbPełnoletnich1 = from Osoba osoba in osoby
                                         where osoba.Wiek >= 18
                                         orderby osoba.Nazwisko descending
                                         //select osoba;
                                         //select new { osoba.Imię, osoba.Nazwisko, osoba.NumerTelefonu };
                                         //select new Osoba() { Imię = osoba.Imię, Nazwisko = osoba.Nazwisko, Wiek = osoba.Wiek, NumerTelefonu = osoba.NumerTelefonu };
                                         select (Osoba)osoba.Clone();

            listaOsóbPełnoletnich1.Wyświetl();

            /*
            var listaOsóbPełnoletnich2 = 
                osoby.
                Where((Osoba osoba) => { return osoba.Wiek >= 18; }).
                OrderByDescending((Osoba osoba) => { return osoba.Nazwisko; }).
                Select((Osoba osoba) => { return osoba; });
            */

            var listaOsóbPełnoletnich2 =
                osoby.
                Where(osoba => osoba.Wiek >= 18).
                OrderByDescending(osoba => osoba.Nazwisko).
                //Select(osoba => osoba);
                //Select(osoba => new Osoba() { Imię = osoba.Imię, Nazwisko = osoba.Nazwisko, Wiek = osoba.Wiek, NumerTelefonu = osoba.NumerTelefonu });
                Select(osoba => (Osoba)osoba.Clone());

            Console.WriteLine("==========================");

            listaOsóbPełnoletnich2.Wyświetl();

            listaOsóbPełnoletnich2.ElementAt(0).Imię = "Bill";
            Osoba[] tablicaOsóbPełnoletnich = listaOsóbPełnoletnich2.ToArray();
            tablicaOsóbPełnoletnich[0].Imię = "Bill";

            listaOsóbPełnoletnich2.Wyświetl();
            tablicaOsóbPełnoletnich.Wyświetl();
            osoby.Wyświetl();

            Console.WriteLine("==========================");

            Console.WriteLine(osoby.All(o => o.Wiek >= 18));
            Console.WriteLine(osoby.Any(o => o.Wiek >= 18));

            Console.WriteLine(osoby.Max(o => o.Wiek));
            Console.WriteLine(osoby.FirstOrDefault(o => o.Wiek == osoby.Max(o => o.Wiek), Osoba.OsobaPusta));
        }

        static void Main2(string[] args)
        {
            var grupyOsóbOTychSamychNazwiskach = from osoba in osoby
                                                 group osoba by osoba.Nazwisko.Substring(0, osoba.Nazwisko.Length - 1) into grupa
                                                 select grupa;

            Console.WriteLine("Grupy:");
            foreach(var grupa in grupyOsóbOTychSamychNazwiskach)
            {
                Console.WriteLine($"Osoby z grupy {grupa.Key}:");
                grupa.Wyświetl();
            }
        }

        static void Main3(string[] args)
        {
            var listaOsóbPełnoletnich = from Osoba osoba in osoby
                                         where osoba.Wiek >= 18
                                         orderby osoba.Nazwisko descending
                                         select osoba;

            var listaOsóbKobiecych = from osoba in osoby
                                     where osoba.Imię.EndsWith("a")
                                     orderby osoba.Nazwisko descending
                                     select osoba;

            listaOsóbPełnoletnich.Wyświetl();
            listaOsóbKobiecych.Wyświetl();

            var listaKobietPełnoletnich = listaOsóbPełnoletnich.Intersect(listaOsóbKobiecych);
            listaKobietPełnoletnich.Wyświetl();

            //var listaKobietLubPełnoletnich = listaOsóbPełnoletnich.Concat(listaOsóbKobiecych).Distinct();
            var listaKobietLubPełnoletnich = listaOsóbPełnoletnich.Union(listaOsóbKobiecych);
            listaKobietLubPełnoletnich.Wyświetl();

            var listaKobietNiepełnoletnich = listaOsóbKobiecych.Except(listaOsóbPełnoletnich);
            listaKobietNiepełnoletnich.Wyświetl();
        }

        static void Main4(string[] args)
        {
            osoby.Wyświetl();

            var personalia = from osoba in osoby
                             orderby osoba.Id
                             select new { osoba.Id, osoba.Imię, osoba.Nazwisko };

            var numeryTelefonów = from osoba in osoby
                                  select new { osoba.Id, osoba.NumerTelefonu };

            personalia.Wyświetl();
            numeryTelefonów.Wyświetl();

            var osobyPołączone = from _personalia in personalia
                                 join numerTelefonu in numeryTelefonów
                                 on _personalia.Id equals numerTelefonu.Id
                                 select new
                                 {
                                     _personalia.Id, _personalia.Imię, _personalia.Nazwisko,
                                     Id2 = numerTelefonu.Id, numerTelefonu.NumerTelefonu
                                 };

            osobyPołączone.Wyświetl();
        }

        static void Main(string[] args)
        {
            //Linq to XML
            XDocument xml = new XDocument(
                new XDeclaration("1.0", "utf-8", "yes"),
                new XElement("osoby",                
                from osoba in osoby
                where osoba.Wiek >= 18
                orderby osoba.Nazwisko
                select new XElement("osoba",
                    new XAttribute("id", osoba.Id),
                    new XElement("imię", osoba.Imię),
                    new XElement("nazwisko", osoba.Nazwisko),
                    new XElement("wiek", osoba.Wiek)
                    )
                ));
            xml.Save("osoby.xml");
        }
    }
}
