﻿namespace TypyOgólne
{
    using ParaInt = Para<int, int>;
    using ParaDouble = Para<double, double>;

    internal class Program
    {
        private readonly static Random r;

        static Program() //konstruktor statyczny
        {
            r = new Random();
        }

        private static void Wyświetl<T>(IEnumerable<T> kolekcja)
        {
            Console.WriteLine($"Wyświetlam kolekcję typu {kolekcja.GetType().FullName}");
            foreach (T element in kolekcja)
            {
                Console.WriteLine(element);
            }
        }

        static void MainPara(string[] args)
        {
            ParaInt[] pi = new ParaInt[10];
            for (int i = 0; i < pi.Length; i++)
            {
                pi[i] = new ParaInt(r.Next(5), r.Next(5));
            }
            Wyświetl(pi);
            Array.Sort(pi);
            Wyświetl(pi);

            Para<int, double>[] pid = new Para<int, double>[10];
            for (int i = 0; i < pid.Length; i++)
            {
                pid[i] = new Para<int, double>(r.Next(5), r.NextDouble());
            }
            Wyświetl(pid);
            Array.Sort(pid);
            Wyświetl(pid);
        }

        static void Main(string[] args)
        {
            //object o = "1";
            //string s = (object)"1";

            ITypInwariantny<object> o11 = new TypInwariantny<object>();
            TypInwariantny<object> o12 = new TypInwariantny<object>();
            ITypInwariantny<string> o13 = new TypInwariantny<string>();
            TypInwariantny<string> o14 = new TypInwariantny<string>();
            //ITypInwariantny<object> o15 = new TypInwariantny<string>();
            //TypInwariantny<object> o16 = new TypInwariantny<string>();
            //ITypInwariantny<string> o17 = new TypInwariantny<object>();
            //TypInwariantny<string> o18 = new TypInwariantny<object>();

            ITypKontrawariantny<object> o21 = new TypKontrawariantny<object>();
            TypKontrawariantny<object> o22 = new TypKontrawariantny<object>();
            ITypKontrawariantny<string> o23 = new TypKontrawariantny<string>();
            TypKontrawariantny<string> o24 = new TypKontrawariantny<string>();
            //ITypKontrawariantny<object> o25 = new TypKontrawariantny<string>();
            //TypKontrawariantny<object> o26 = new TypKontrawariantny<string>();
            ITypKontrawariantny<string> o27 = new TypKontrawariantny<object>();
            //TypKontrawariantny<string> o28 = new TypKontrawariantny<object>();

            ITypKowariantny<object> o31 = new TypKowariantny<object>();
            TypKowariantny<object> o32 = new TypKowariantny<object>();
            ITypKowariantny<string> o33 = new TypKowariantny<string>();
            TypKowariantny<string> o34 = new TypKowariantny<string>();
            ITypKowariantny<object> o35 = new TypKowariantny<string>();
            //TypKowariantny<object> o36 = new TypKowariantny<string>();
            //ITypKowariantny<string> o37 = new TypKowariantny<object>();
            //TypKowariantny<string> o38 = new TypKowariantny<object>();
        }
    }
}
