﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace TypyOgólne
{
    public class Para<T, S> : IComparable<Para<T, S>>
        where T : IComparable<T>
        where S : IComparable<S>
    {
        public T pierwsza = default(T);
        public S druga = default(S);

        public Para(T pierwsza, S druga)
        {
            this.pierwsza = pierwsza;
            this.druga = druga;
        }

        public override string ToString()
        {
            return $"{pierwsza}\t{druga}";
        }

        public int CompareTo(Para<T, S>? other)
        {
            int wartość = pierwsza.CompareTo(other.pierwsza);
            if (wartość != 0) return wartość;
            else return druga.CompareTo(other.druga);
        }
    }
}
