﻿using System.Diagnostics;

namespace Roszerzenia
{
    static class Rozszerzenia
    {
        public static string UsuńApostrof(this string s)
        {
            return s.Replace('\'', '#');
        }

        public static string UsuńApostrof(this string s, char zamiennik = '#')
        {
            return s.Replace('\'', zamiennik);
        }

        public static string UsuńApostrof(this string s, Func<char,char> zmieniacz)
        {
            if (zmieniacz == null) throw new ArgumentNullException(nameof(zmieniacz));
            //return s.Replace('\'', zamiennik);
            string wynik = "";
            foreach(char c in s.ToCharArray())
                wynik += zmieniacz(c);
            return wynik;
        }

        public static string PobierzNazwęTypu(this object argument)
        {
            return argument.GetType().Name;
        }

        public static void WydrukujObiekt(this object argument, bool dodajZnakKońcaLinii = true)
        {
            Console.Write(argument.ToString());
            if (dodajZnakKońcaLinii) Console.WriteLine();
        }
    }

    internal class Program
    {
        static void Main(string[] args)
        {
            string s = "Hel\'lo, W\'orld!";

            string s1 = Rozszerzenia.UsuńApostrof(s);
            Console.WriteLine(s1);

            string s2 = s.UsuńApostrof('?');
            Console.WriteLine(s2);

            string s3 = s.UsuńApostrof(
                (char c) =>
                {
                    if (c == '\'') return '!';
                    else return c;
                }
                );
            Console.WriteLine(s3);

            string s4 = 1.PobierzNazwęTypu();
            Console.WriteLine(s4);

            1.WydrukujObiekt();
        }
    }
}
