﻿namespace ReversiSilnik
{
    public class ReversiSilnikAI : ReversiSilnik
    {
        public ReversiSilnikAI(int numerGraczaRozpoczynającego,
                               int szerokośćPlanszy = 8, int wysokośćPlanszy = 8)
            : base(numerGraczaRozpoczynającego, szerokośćPlanszy, wysokośćPlanszy)
        {
        }

        private struct MożliwyRuch : IComparable<MożliwyRuch>
        {
            public WspółrzędnePola WspółrzędnePola;
            public int Priorytet;

            public MożliwyRuch(WspółrzędnePola współrzędnePola, int priorytet)
            {
                this.WspółrzędnePola = współrzędnePola;
                this.Priorytet = priorytet;
            }

            public int CompareTo(MożliwyRuch innyRuch)
            {
                return innyRuch.Priorytet - this.Priorytet;
            }
        }

        public WspółrzędnePola ProponujNajlepszyRuch()
        {
            //deklaracja tablicy możliwych ruchów
            List<MożliwyRuch> możliweRuchy = new List<MożliwyRuch>();

            int skokPriorytetu = SzerokośćPlanszy * WysokośćPlanszy;

            //poszukiwanie możliwych ruchów
            for (int poziomo = 0; poziomo < SzerokośćPlanszy; poziomo++)
                for (int pionowo = 0; pionowo < WysokośćPlanszy; pionowo++)
                {
                    WspółrzędnePola współrzędnePola = new WspółrzędnePola(poziomo, pionowo);
                    if (PobierzStanPola(współrzędnePola) == 0)
                    {
                        //liczba zajętych pól
                        int priorytet = połóżKamień(współrzędnePola, true);
                        if (priorytet > 0)
                        {
                            MożliwyRuch mr = new MożliwyRuch(współrzędnePola, priorytet);

                            //pole w rogu +
                            if ((mr.WspółrzędnePola.Poziomo == 0 ||
                                 mr.WspółrzędnePola.Poziomo == SzerokośćPlanszy - 1) &&
                                (mr.WspółrzędnePola.Pionowo == 0 ||
                                 mr.WspółrzędnePola.Pionowo == WysokośćPlanszy - 1))
                                mr.Priorytet += skokPriorytetu * skokPriorytetu;

                            //pole sąsiadujące z rogiem na przekątnych -
                            if ((mr.WspółrzędnePola.Poziomo == 1 ||
                                 mr.WspółrzędnePola.Poziomo == SzerokośćPlanszy - 2) &&
                                (mr.WspółrzędnePola.Pionowo == 1 ||
                                 mr.WspółrzędnePola.Pionowo == WysokośćPlanszy - 2))
                                mr.Priorytet -= skokPriorytetu * skokPriorytetu;

                            //pole sąsiadujące z rogiem w pionie -
                            if ((mr.WspółrzędnePola.Poziomo == 0 ||
                                 mr.WspółrzędnePola.Poziomo == SzerokośćPlanszy - 1) &&
                                (mr.WspółrzędnePola.Pionowo == 1 ||
                                 mr.WspółrzędnePola.Pionowo == WysokośćPlanszy - 2))
                                mr.Priorytet -= skokPriorytetu * skokPriorytetu;

                            //pole sąsiadujące z rogiem w poziomie -
                            if ((mr.WspółrzędnePola.Poziomo == 1 ||
                                 mr.WspółrzędnePola.Poziomo == SzerokośćPlanszy - 2) &&
                                (mr.WspółrzędnePola.Pionowo == 0 ||
                                 mr.WspółrzędnePola.Pionowo == WysokośćPlanszy - 1))
                                mr.Priorytet -= skokPriorytetu * skokPriorytetu;

                            //pole na brzegu +
                            if (mr.WspółrzędnePola.Poziomo == 0 ||
                                mr.WspółrzędnePola.Poziomo == SzerokośćPlanszy - 1 ||
                                mr.WspółrzędnePola.Pionowo == 0 ||
                                mr.WspółrzędnePola.Pionowo == WysokośćPlanszy - 1)
                                mr.Priorytet += skokPriorytetu;

                            //pole sąsiadujące z brzegiem -
                            if (mr.WspółrzędnePola.Poziomo == 1 ||
                                mr.WspółrzędnePola.Poziomo == SzerokośćPlanszy - 2 ||
                                mr.WspółrzędnePola.Pionowo == 1 ||
                                mr.WspółrzędnePola.Pionowo == WysokośćPlanszy - 2)
                                mr.Priorytet -= skokPriorytetu;

                            //dodanie do listy możliwych ruchów
                            możliweRuchy.Add(mr);
                        }
                    }
                }

            //wybór pola o największym priorytecie
            if (możliweRuchy.Count > 0)
            {
                możliweRuchy.Sort();
                return możliweRuchy[0].WspółrzędnePola;
            }
            else
            {
                throw new Exception("Brak możliwych ruchów");
            }
        }
    }
}
