﻿namespace Reversi2026
{
    internal static class MieszanieKolorów
    {
        public static Color Lerp(this Color kolor, Color innyKolor, double waga)
        {
            float r = (float)(waga * kolor.Red + (1 - waga) * innyKolor.Red);
            float g = (float)(waga * kolor.Green + (1 - waga) * innyKolor.Green);
            float b = (byte)(waga * kolor.Blue + (1 - waga) * innyKolor.Blue);
            return Color.FromRgb(r, g, b);
        }

        public static SolidColorBrush Lerp(this SolidColorBrush pędzel, SolidColorBrush innyPędzel, double waga)
        {
            return new SolidColorBrush(Lerp(pędzel.Color, innyPędzel.Color, waga));
        }
    }
}