! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The zgauss function returns the value of V(r(i))*r(i) where V is
! *     the nuclear potential for the Gaussian charge distribution model
! *
! *****
function zgauss(i)
  use global
  use params

  implicit none
  integer :: i,izz1
  real (PREC) :: atw,at3,eta1,fmtoau,rrms,rrmsfm,zgauss

!     Evaluate the nuclear potential for Gaussian models.  

  fmtoau=1.0e-13_PREC/ainfcm

  !     set atomic weight 
  
  izz1=nint(z)
  atw=atweight(izz1)
  at3=atw**(one/three)
  rrmsfm = 0.836_PREC*at3+0.570_PREC
  
  !     change units from fm into bohr
  
  rrms = rrmsfm*fmtoau
  
  !     exponent of the Gaussian distribution $\rho_0 exp(-\eta r^2)$
  !     rrms=(3/(2\eta)^{1/2)
  
  eta1=3.d0/(2.d0*rrms*rrms)
  
  !     making use of F77 intrinsic function 
  !     erf(x)=2/(Pi)^(1/2)*int_)^x exp(-t^2)dt
  !     if available
  
  zgauss=z*erf(sqrt(eta1)*r(i))
  
end function zgauss

