! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *	The ykf subroutine calculates the potential function 'yk' for
! *	the i-th and j-th orbitals
! *
! *****
subroutine ykf(i,j,k)
  use global
  use params

  implicit none
  integer :: i,j,k,m,mm
  real (PREC) :: a,a2,a3,a34,ai,an,c,f1,f2,f3,f4,f5,h90
!  integer, external :: 
!  real (PREC), external :: 

  call zk(i,j,k)
  
  a = eh**(k+1)
  c = 2*k+1
  a2 = a*a
  h90 = c*h3/d30
  a3 = a2*a*h90
  ai = h90/a
  an = 114.d0*a*h90
  a34 = 34.d0*h90
  f1 = yk(no)*eh**k
  f2 = yk(no)
  f3 = yk(no-1)
  f4 = yk(nd)
  
  do mm = 2,nd
     m = no-mm
     f5 = yk(m-1)
     yk(m) = yk(m+2)*a2 + ( an*f3 + a34*(f4+a2*f2)-f5*ai-f1*a3)
     f1 = f2
     f2 = f3
     f3 = f4
     f4 = f5
  enddo
  yk(1) = yk(3)*a2+c*h3*(f4 + d4*a*f3 + a2*f2)
  
end subroutine ykf
