! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The ykdft subroutine fills for orbital i the vxch array with
! *     (-z+yk)/r+vdft values at grid points
! *
! *****
subroutine ykdft(i)
  use global
  use ode
  use params
  use relativity
  use state

  implicit none
  integer :: i,k
  real (PREC), external :: zvar 

  call potl(i)
  
  
  if (qc(i,1).eq.d1) then
     do k=1,no
        vxch(k)=(-zvar(k)+yr(k))/r(k)
!!        print *,'ykdft 1: k,vxch',k,vxch(k)
     enddo
  else
     
     !        FIXME yr does not include contributions that are canceled out by exchange
     !        terms (if it does total energy gets worse)

     if     (ixpot.eq.1) then
        call potllda(i)
        
     elseif (ixpot.eq.2) then
        call potlcg1(i)
        do k=1,no
!!           print *,'ykfdft 1a: k,vdft',k,vdft(k)
     enddo

     elseif (ixpot.eq.3) then
        call potlcg2(i)
     endif
     
     do k=1,no
        vxch(k)=(-zvar(k)+yr(k))/r(k) + vdft(k)
!     if (mod(k,100)==0 ) print *,'ykdft 2: k,vxch',k,vdft(k),vxch(k)
     enddo
  endif

end subroutine ykdft
    

