! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *     The xch function computes a function x such that for       
! *        iopt = 1  x =sqrt(r)*true exchange function                  
! *        iopt = 2  x = true exchange function/sqrt(r)             
! *        iopt = 3  x = r**3/2*(true exchange + off-diagonal terms)
! *****
subroutine xch(i,iopt)
  use global
  use coeffs
  use params
  use relativity
  use state
  use wave

  implicit none
  integer :: i,i1,i2,ii,iii,ij1,ij2,ijt,iopt,j,jj,k,lj,m,n1,n2 
  real (PREC) :: c,cc
  real (PREC), external :: bb,hl,quadr,rk

  do j=1,no
     x(j) = d0
  enddo

  do j=1,nwf
     do k=1,5
        c = b(i,j,k)*d2
        if(abs(c).le.1.d-10) go to 3
        call ykf(i,j,2*(k-1) + abs(l(i) - l(j)))
        do jj =1,no
           x(jj) = x(jj)+ c*yk(jj)*p(j,jj)
        enddo
3       continue
     enddo
2    continue   
  enddo

  if (rscan(i)) go to 4
  if(nr .eq. 0) go to 22
  
  do ii=1,nr
     n1 = ncri(ii)
     n2 = ncrj(ii)
     c = wt(n1)*wt(n2)*cr(ii)/sum(i)
     do i2=1,2
        do i1=1,2
           if (i1r(ii) .ne. i) go to 13
           cc=c
           if(iq(ii).ne.0) cc=cc*quadr(io(ii),jo(ii),izero)**iq(ii)
           call ykf(i2r(ii),j2r(ii),kr(ii))
           m = j1r(ii)
           do j=1,no
              x(j)=x(j)+cc*p(m,j)*yk(j)
           enddo
           
13         iii = i1r(ii)
           i1r(ii)= i2r(ii)
           i2r(ii)= iii
           iii = j1r(ii)
           j1r(ii) = j2r(ii)
           j2r(ii) = iii
12         continue
        enddo
        iii = i1r(ii)
        i1r(ii) = j1r(ii)
        j1r(ii) = iii
        iii = i2r(ii)
        i2r(ii)= j2r(ii)
        j2r(ii)= iii
11      continue
     enddo
     ij1=io(ii)
     ij2=jo(ii)
     k=1
21   if(ij1.ne.i) go to 19
     cc=c*iq(ii)*rk(i1r(ii),i2r(ii),j1r(ii),j2r(ii),kr(ii))*quadr(io(ii),jo(ii),izero)**(iq(ii)-ione)
     do j=1,no
        x(j)=x(j)+cc*r(j)*p(ij2,j)
     enddo
19   ijt=ij1
     ij1=ij2
     ij2=ijt
     k=k+1
     if(k.eq.2) go to 21
10   continue
  enddo
  
  !   *****   and contribution from the l integrals

22 continue

  if(nl.eq.0) go to 4
  do ii=1,nl
     n1=ncli(ii)
     n2=nclj(ii)
     c=wt(n1)*wt(n2)*cl(ii)/sum(i)
     do i1=1,2
        if(ili(ii).ne.i) go to 32
        call diff(ilj(ii))
        cc=c
        if (lq(ii) .ne. 0) cc = cc*quadr(ilo(ii),jlo(ii),izero)**lq(ii)
        do j=1,no
           x(j)=x(j) +cc*yk(j)/r(j)
        enddo
32      if(ilo(ii).ne.i) go to 35
        lj=jlo(ii)
        cc=c*lq(ii)*hl(ili(ii),ilj(ii))
        if(lq(ii).gt.1) cc=cc*quadr(ilo(ii),jlo(ii),izero)**(lq(ii)-1)
        do j=1,no
           x(j)=x(j) +cc*r(j)*p(lj,j)
        enddo
35      iii=ili(ii)
        ili(ii)=ilj(ii)
        ilj(ii)=iii
        iii=ilo(ii)
        ilo(ii)=jlo(ii)
        jlo(ii)=iii
     enddo
  enddo
  


4 continue
!  print *,'xch: iopt=',iopt
  go to (15,16,17),iopt

16 do j = 1,no
     x(j) = x(j)/r(j)
  enddo
  go to 15

17 do j =1,no
     x(j) = r(j)*x(j)
  enddo
  
  if(irel.eq.0) then
     do j = 1,nwf
        c = e(i,j)
!        print *,'xch: i,j,e(i,j)',i,j,e(i,j)
        if (c .eq. d0 .or. (j .eq. i)) go to 7
        do jj = 1,no
           x(jj) = x(jj) + c*p(j,jj)*rr(jj)
        enddo
7       continue
     enddo
  else
! FIXME
     do j=1,nwf
        c=e(i,j)
        if(c.eq.0d0.or.(j.eq.i)) go to 77
        do jj=1,no
           x(jj)=x(jj)+c*p(j,jj)*rr(jj)/bb(j,jj)
        enddo
77      continue
     enddo
  endif


! FIXME xch !!!!!

  ! do jj=1,no
  !    x(jj)=x(jj)+c*p(j,jj)*rr(jj)/bb(j,jj)
  ! enddo

  !   *****   check if exchange is zero: if so, method 2 should be used.
  
15 if(meth(i).eq.2) return

  if(abs(x(1))+abs(x(2))+abs(x(3)).eq.0d0) meth(i)=2
  
end subroutine xch
