! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The wavefn subroutine determins the initial estimates of the wave
! *     functions.
! *
! *****
subroutine wavefn
  use global
  use coeffs
  use input
  use ode
  use params
  use relativity
  use wave

  implicit none

  character*4 :: elt
  character*8, dimension(3,3) :: title

!  integer :: i,ii,im,iqpottmp,j,k,m
  integer :: i,ii,im,ind3,iqpottmp,j,k,not
  real (PREC) :: pn,pnn,rhot,rmaxt,zz2
  real (PREC), external :: hl,hnorm,hwf,quadr
  

  data title/' scaled ','        ','        ',' screene', 'd hydrog','enic    ',' unchang','ed      ','        '/
  
  !     *****  generate arrays for r,r*r and sqrt(r) with a constant mesh
  !     *****  size in the log(z*r) variable
  
  do i=1,no
     r(i)= exp(rho)/z
     rr(i) = r(i)*r(i)
     r2(i) = sqrt(r(i))
     rho = rho + h
  enddo
  rho = rho - no*h
  
  !     *****  set paramters for electrons and initialize functions


  do i = 1,nwf
     maxv(i) = no
     pn = hnorm(n(i),l(i),z-s(i))

     ind3=ind(i)+3
     go to (7,7,8,9),ind3
     
     !        *****  read data cards for electron i if ind=-1 on 'electron' card
     
7    continue


     read(iuf,12) atm(i),trm(i),zz(i),not,rhot,rmaxt
!     write(*,12) atom,term,zz(i),not,rhot,rmaxt

     if ( not /= no ) then
!        write(ouf,'("    wavefn: the file contains wrong number of grid points" )')
        write(*,'("    wavefn: the file contains wrong number of grid points" )')
     endif

     if ( abs(rhot/rho-1.0_PREC) > 1000.0*precis ) then
!        write(ouf,'("    wavefn: the file contains wrong rho value ",1pe12.4)') rhot
        write(*,'("    wavefn: the file contains wrong rho value ",1pe12.4)') rhot
     endif



     read(iuf,10) elt,m,e(i,i),ek(i),az(i),zrl(i),dlr(i),dpm(i),acc(i)
!!     write(*,10) elt,m,e(i,i),ek(i),az(i),zrl(i),dlr(i),dpm(i),acc(i)
     read(iuf,11) (p(i,j),j=1,no)
!     read(iuf,13) 
     read(iuf,11) (y(i,j),j=1,no)
     read(iuf,11) (e(i,j),j = 1,nwf)

        ! write(ouf,3) atom,term,z,no,rho,rmax
        ! write(*,3) atom,term,z,no,rho,rmax
        ! write(ouf,4) el(i),mx,e(i,i),ek(i),az(i),zrl(i),dlr(i),dpm(i),acc(i)
        ! write(*,4)   el(i),mx,e(i,i),ek(i),az(i),zrl(i),dlr(i),dpm(i),acc(i)



!     dpm(i)=10.d0
!10   format(6x,a6,6x,a6,9x,a3,i6,f6.0,/5(4x,d22.15),d22.15)

10   format(11x,a3,7x,i6,4x,1pd22.15,5x,1pd22.15,5x,1pd22.15,6x,1pd22.15,6x,1pd22.15,6x,1pd22.15,6x,1pd22.15)
11   format(4d22.15)
12   format(7x,a6,7x,a6,4x,f6.2,5x,i6,6x,1pd22.15,7x,1pd22.15)
13   format(//)

     !        if ind(i)=-2 reverse the sign of e(i,i) to indicate that
     !        this parameter should not be calculated in the first 
     !        iteration by solve routine
     
     if(ind(i).eq.-2) e(i,i)=-e(i,i)
	
     !        *****  scale results if cards are for an atom with a different z
     
     if (z .eq. zz(i)) go to 20

! FIXME
!     zz2 = z/zz(i)

!     do j=1,m
!        p(i,j)= p(i,j)*zz2
!     enddo

20   continue
     if (m .eq. no) go to 4
     maxv(i) = m
     
     !        *****  set remaining values in the range = 0
     
     m = m +1
     do j=m,no
        p(i,j) = d0
     enddo
!     print *,'wavefn: m,no',m,no

     if(ind3.eq.1) go to 5
     go to 4
     
     !        ***** determine estimates of the wave functions by the screened
     !        ***** hydrogenic approximation
     
8    continue

     do j=1,no
        p(i,j) = pn*hwf(n(i),l(i),z-s(i),r(j))/r2(j)
     enddo
     
     !        *****  if az(i) was not specified on input data, compute
     
24   continue

     az(i) = pn*(d2*(z - d5*s(i))/n(i))**(l(i) + 1)
     
     !        *****  orthogonalize to inner functions
4    continue
     
     !        do not orthogonalize orbitals when retrieving them from disk
     
     if (ind(i).ne.-1) then

        if (i .eq. 1 .or. i .lt. ib) go to 5

        im = i - 1
        do ii =1,im
           if (l(i) .ne. l(ii) .or. n(i) .eq. n(ii) ) go to 6
           if (.not.ortho.and.abs(a(i,ii,1)).lt.1.e-20_PREC) go to 6
           pn = quadr(i,ii,izero)
           pnn = sqrt(d1 - pn*pn)
           if (p(i,1) - pn*p(ii,1) .lt. d0) pnn = -pnn
           do j = 1,no
              p(i,j) =(p(i,j) - pn*p(ii,j))/pnn
           enddo
           if (irel.eq.0) then
              ek(i) = -d5*hl(i,i)
           else
              irel=0
              ek(i) = -d5*hl(i,i)
              irel=1
           endif
           
6          continue
        enddo
     endif
5    continue
     !        *****  compute y0(i,i) and store
9    continue
  enddo

  call grange


! FIXME
  ! if (iuf/=0) then
  !    do j=1,no
  !       y(i,j)=yk(j)
  !    enddo
  ! endif


  
  write(ouc,14)
14 format(/ 9x,18hinitial estimates  /9x,2hnl,5 x,5hsigma,6x,5he(nl),4x,6hek(nl),4x, &
        6 haz(nl),5x,9hfunctions/)

  !     *****  compute one-electron energy parameters if they were not
  !     *****  specified on input.
  
  ! FIXME
  if (irel.eq.0) then
     do i = 1,nwf
        if (iuf == 0) then
           if ( ek(i) .eq. 0) ek(i) = -d5*hl(i,i)
           ! set initial orbital energy to the screened hydrogenic one
           e(i,i)=-(z-s(i))*(z-s(i))/dble(2*n(i)*n(i))
        endif
22      k = ind(i) + 2
        if(ind(i).eq.-2) k=1
17      write(ouc,19) el(i),s(i),e(i,i)/d2,ek(i),az(i),(title(j,k),j=1,3)
19      format(9x,a3,f9.2,f11.3,f10.3,f10.3,a12,2a8)
     enddo
  else
     return

! FIXME 
!     irel=0
     iqpottmp=iqpot
!     iqpot=4
     do i = 1,nwf

        if ( ek(i) .eq. 0) ek(i) = -d5*hl(i,i)
        e(i,i)=-(z-s(i))*(z-s(i))/dble(2*n(i)*n(i))
        call relpot(i)

        ! set initial orbital energy to the screened hydrogenic one
        e(i,i)=-d5*d5*hl(i,i)
!        e(i,i)=ek(i)/d2
        k = ind(i) + 2
        if(ind(i).eq.-2) k=1
        write(ouc,19) el(i),s(i),e(i,i),ek(i),az(i),(title(j,k),j=1,3)
     enddo
     iqpot=iqpottmp
!     irel=1
  endif

end subroutine wavefn
