! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The summary subroutine evaluates and prints the total energy and
! *     its contributions and also various one-electron integrals
! *
! *****
subroutine summry(ett)
  use global
  use coeffs
  use params
  use relativity
  use state
  use wave

  implicit none
  character*1 d,f,g
  character*4 bl4
  
  integer :: i,i1,i2,ii,indmc,j,j1,j2,k,kf,kk,lbmax,li,lj,minv,n1,n2,ntrgst,nwf11
  real (PREC) :: c,cc,ce,cedft,cont,eii,ekinp,ekt,en,enpot,epotl,ett,qi,qj,r1,r4, &
       ratio,rh,rm,rmm,sc,sp,xen
  integer, dimension(5) :: iw 
  integer, dimension(3,4,3) :: cv
  integer, dimension(3,4,4) :: cn

  real (PREC), dimension(3) :: ss
  real (PREC), dimension(5) :: out
  real (PREC), dimension(20) :: r3

  real (PREC), external :: fk,gk,hl,quadr,rk,sm,sn,v


  data cv/-1.00_PREC,-.60_PREC,0.0_PREC,-.60_PREC,-.20_PREC,-.17142857142857140_PREC,.20_PREC,       &
       2*-.085714285714285710_PREC,.25714285714285710_PREC,.085714285714285710_PREC,                 &
       -.0285714285714285710_PREC,2*0.0_PREC,-.42857142857142860_PREC,0.0_PREC,                      &
       -.34285714285714280_PREC,-.23809523809523800_PREC,-.51428571428571430_PREC,                   &
       -.28571428571428570_PREC,-.085714285714285710_PREC,-.47619047619047620_PREC,                  &
       -.05714285714285710_PREC,-.06493506493506490_PREC,8*0.0_PREC,                                 &
       -.19480519480519480_PREC,0.0_PREC,-.25974025974025970_PREC,-.17482517482517480_PREC/

  data cn/ 2.0_PREC,1.80_PREC,0.0_PREC,-1.0_PREC,.80_PREC,.857142857142857140_PREC,.80_PREC,          &
       -.60_PREC,.51428571428571430_PREC,1.2857142857142860_PREC,.51428571428571430_PREC,             &
       -.42857142857142860_PREC,-1.0_PREC,-1.20_PREC,1.7142857142857140_PREC,0.0_PREC,                &
       -.14285714285714280_PREC,-.047619047619047620_PREC,-1.68571428571428570_PREC,                  &
       .17142857142857140_PREC,-.25714285714285710_PREC,-2.4761904761904760_PREC,                     &
       -.71428571428571420_PREC,-.14285714285714280_PREC,2*0.0_PREC,                                  &
       -1.2857142857142860_PREC,0.0_PREC,-.34285714285714280_PREC,-.47619047619047620_PREC,           &
       .51428571428571430_PREC,0.0_PREC,.033766233766233770_PREC,.95238095238095240_PREC,             &
       -.36883116883116880_PREC,-.06493506493506490_PREC,8*0.0_PREC, -.19480519480519480_PREC,        &
       0.0_PREC,.25974025974025970_PREC,0.0_PREC/
  
  data d/' '/,f/'F'/,g/'G'/,bl4/'    '/

  write (ouc,9) atom,term
9 format(/// 24x,5hAtom ,a6,3x,5hTerm ,a6//40x,13hmean value of,1x,22hone electron integrals /2x,2hnl,10x,7h  E(nl), &
       7x,8h  Az(nl),5x,5hsigma,4x,6h1/r**3,7x,3h1/r,9x,1hr,8x,4hr**2,7x,5hI(nl),8x,2hKe)
  
  en = d0
  
  !     *****  compute and print one-electron parametters

! FIXME set lbmax somewhere
  lbmax=0
  if(ouf.eq.0) go to 432
  if(indmc.eq.2) go to 209
  
  nwf11=nwf
  if(indmc.eq.1) nwf11=ntrgst
  
201 format(33h Coulomb potential for electron  ,a3)
202 format(4d20.13)
  
204 format('integrals')   
205 format('integral',i2)
  
209 continue
432 continue
  
  enpot=d0
  do i = 1,nwf
     r1  = quadr(i,i,-ione)
     rm  = quadr(i,i,ione)
     rmm = quadr(i,i,itwo)
     
     eii=e(i,i)/2.0_PREC
     r4=quadr(i,i,ifour)
     
     enpot=enpot+sum(i)*z*r1
     ekinp = ek(i) + z*r1
     en = en+ sum(i)*ekinp
     rh = 3*n(i)*n(i) - l(i)*(l(i) + 1)
     sc = z - d5*rh/rm
     s(i) = sc
     r3(i) = d0
     
     write(ouc,15) el(i),eii,az(i),sc,r3(i),r1,rm,rmm,ek(i),ekinp
     
15   format(2x,a3,f20.12,f12.5,f9.4,4f11.6,4f12.5)
214  format(2x,'el      E(nl)   Az(nl)   sigma  1/r**3  /','  1/r      r      r**2   I(nl)  /','  Ke')
215  format(2x,a3,4d22.15,/5x,4d22.15,/5x,4d22.15)
     
  enddo
  
  if ( nl .eq. 0 ) go to 31
  
  !     *****  add contribution from the 'l' integrals
  
  do i = 1,nl
     n1 = ncli(i)
     n2 = nclj(i)
     cc = cl(i)*wt(n1)*wt(n2)
     if (lq(i) .ne. 0) cc = cc*quadr(ilo(i),jlo(i),izero)**lq(i)
     cont = cc*(hl(ili(i),ilj(i)) - d2*z*quadr(ili(i),ilj(i),-ione))
     en = en + cont
  enddo

31 epotl = ett - en
  ratio =-epotl/en
  call ecoul(ce)
  
  cedft=d0
  ekt=d0
  do i=1,nwf
     cedft=cedft+fk(i,i,0)
     ekt=ekt+ek(i)
  enddo
  
  xen=epotl+enpot-ce
  if (irel.eq.0) then
     write (ouc,26) ett,en,epotl,ce,xen,ce+cedft,xen-cedft,ratio
  else
     write (ouc,926) ett,en,epotl,ce,xen,ce+cedft,xen-cedft
  endif
  
26 format(/4x,"total energy         = ",d24.14,  &
        /4x,"kinetic energy       = ",d24.14,    &
        /4x,"potential energy     = ",d24.14,    &
        /4x,"Coulomb energy       = ",d24.14,    &
        /4x,"exchange energy      = ",d24.14,    &
        /4x,"Coulomb energy (DFT) = ",d24.14,    &
        /4x,"exchange energy (DFT)= ",d24.14,    &
        /4x,"ratio                = ",d24.14)

926 format(/4x,"total energy         = ",d24.14, &
         /4x,"kinetic energy       = ",d24.14,   &
         /4x,"potential energy     = ",d24.14,   &
         /4x,"Coulomb energy       = ",d24.14,   & 
         /4x,"exchange energy      = ",d24.14,   &
         /4x,"Coulomb energy (DFT) = ",d24.14,   &
         /4x,"exchange energy (DFT)= ",d24.14)   
         

  ! FIXME
  !      call exlda (exchen)
  !      print *,'Exchange (LDA) energy: ',exchen
  
  if ( oud .eq. 0 ) return
  write (oud,126)
126 format(/2x,27hvalues of f and g integrals       /)
  
  !     *****  print tables of 'fk' and 'gk' integrals which were used in
  !     *****  determining the energy

  do j = ib,nwf
     do i = 1,j
        kf = 0
        minv = 0
        do k = 1,5
           if (a(i,j,k) == d0) go to 18
           iw(k) = minv
           out(k) = fk(i,j,minv)
           minv = minv + 2
           kf = kf + 1
        enddo
        
18      if (kf .ne. 0) write(oud,19) (d,f,iw(k),el(i),el(j),out(k),k=1,kf)
!19      format( 2(2x,2a1,i1,1h(,a3,1h,,a3,4h ) =, f10.7,2x))
19      format( 2(2x,2a1,i1,1h(,a3,1h,,a3,4h ) =, 1pe24.15,2x))
        minv = abs(l(i) - l(j))
        kf = 0
        do k = 1,5
           if (b(i,j,k) .eq. d0) go to 25
           iw(k) = minv
           out(k) = gk(i,j,minv)
           minv = minv + 2
           kf = kf + 1
        enddo
25      if (kf .ne. 0) write(oud,19) (d,g,iw(k),el(i),el(j),out(k),k=1,kf)
     enddo
  enddo
  
  if (nr .eq. 0) go to 27
  
  !     *****  print tables of 'rk' integrals
  
  write (oud,21)
21 format(//2x,21hvalues of r integrals  //)
  do i = 1,nr
     i1 = i1r(i)
     i2 = i2r(i)
     j1 = j1r(i)
     j2 = j2r(i)
     out(1) = rk(i1,i2,j1,j2,kr(i))
     write (oud,23) kr(i),el(i1),el(i2),el(j1),el(j2),out(1)
  enddo
23 format(2x,1hr,i1,2h (,2a3,1h,, 2a3,4h ) =, f10.7 )
27 if (nl .eq. 0) go to 13
  
  !     *****  print tables of l'l' integrals
  
  write (oud,28)
28 format(2x,21hvalues of l integrals //)
  do i = 1,nl
     i1 = ili(i)
     j1 = ilj(i)
     out(1) = hl(i1,j1)
     write(oud,30) el(i1),el(j1),out(1)
  enddo
30 format(2x,2hl(,a3,1h,,a3,4h) = ,f16.7)
  
13 write (oud,1)
1 format(//3x,20hspin-orbit parameter,10x,20 hspin-spin parameters/)
  
  !     *****  compute and print spin-orbit and spin-spin parameters
  
  do k = 1,ncfg
     do i = 1,nwf
        qi = qc(i,k)
        li = l(i)
        if (qi .eq. 4*li+2 .or. li .eq. 0 .or. qi .eq. d0) go to 7
        if (li .eq. 4) go to 7
        sp = z*r3(i)*5.843574
        do j = 1,nwf
           if (l(j) .eq. 4) go to 4
           qj = qc(j,k)
           if (qj .eq. d0 .or. i .eq. j) go to 4
           lj = l(j) + 1
           c = qj
           sp = sp - d2*c*sm(i,j,0)
           if (qj .ne. 4*lj-2) go to 4
           do kk = 1,3
              cc = cv(li,lj,kk)
              if (cc .ne. d0) sp = sp -  c*cc*v(i,j,(li+lj)+2*(kk-1-(li+lj)/2))
           enddo
           do kk = 1,4
              cc = cn(li,lj  ,kk)
              if (cc .ne. d0) sp = sp - c*cc*sn(i,j,(li+lj)-3+2*(kk -(li+lj)/2))
           enddo
4          continue
        enddo
        
        c= qi
        if (c .eq. d1) go to 8
        ss(1) = sm(i,i,0)
        c = c + c - d3
        sp = sp - c*ss(1)
        go to (3,11,12), li
11      ss(2) = sm(i,i,2)
        sp = sp + .857142857142857d0*ss(2)
        go to 3
12      ss(2) = sm(i,i,2)
        ss(3) = sm(i,i,4)
        sp = sp + ss(2) + .45454545454545450_PREC*ss(3)
3       write (oud,14) k,el(i),sp,(bl4,el(i),el(i),ss(ii),ii=1,li)
14      format( 1x,i3,6h zeta(,a3,3h( =,f15.6,3x,a4,3hmo(,a3,1h,,a3,4 h) = , f7.4,a4/34x,3hm2(,a3,1h ,a3,4h) = ,f7.4 &
             ,a4/34x,3hm4(,a3,1h,,a3,4h) = ,f7.4)
        go to 7
8       write (oud,14) k,el(i),sp
7       continue
     enddo
  enddo
  
end subroutine summry
