! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     When first is .true. solve computes the potential and exchange
! *     function and initializes variables for the i'th radial
! *     equation. The vector p1 is the solution of the radial equation and
! *     p2 the variation of the solution with respect to the energy
! *     parameter e(i,i).
! *
! *****
subroutine solve (i,first)
  use global
  use ode
  use params
  use relativity
  use wave

  implicit none
  logical*1 :: first
  integer :: i,j,jj,m1,m2,mh
  real (PREC) :: aa,a11,b11,b3,b4,cd,c11,cn,de2,de1,del1,del2,delh,delta,disc,f1,fl,fnum,hw,p1x,p2x,pnorm,rl, &
       v,x1,x2,x3,x4,x5,y1,y2,y3
  real, save :: c,xp,xy
  integer, external :: mmin,mmax 
  real (PREC), external :: hwf,quad,zvar
  real (PREC), dimension(maxno) :: xxsolve,zerotmp

  fn = n(i)
  fl = l(i)
  v = yr(1)/r(1)
  c=d4*dlr(i)+d6
  cd = (fl+d5)*(fl+d5)
  
  !     *****  if first is 'true', call potl and xch and set up arrays
  if (.not. first) go to 17
  
  call potl(i)
  call xch(i,ithree)

  fn = n(i)
  fl = l(i)
  v = yr(1)/r(1)
  !      b4 = z*(fl+d1+d1/d3)/((fl+d1)*(fl+d2))
  !      cn = (d2*z/fn)**(l(i) +1)
  c=d4*dlr(i)+d6
  cd = (fl+d5)*(fl+d5)
  xy = x(1)
  xp = x(2)
  ed = e(i,i)
  
  
  x1 = x(1)
  x2 = x(2)
  x3 = x(3)
  x4 = x(4)
  do j = 3,nd
     x5 = x(j+2)
     x(j) =ch*(-x5+24.0_PREC*(x4+x2) + 194.0_PREC*x3 - x1)/20.0_PREC
     x1 = x2
     x2 = x3
     x3 = x4
     x4 = x5
  enddo
  x(no-1) = ch*(x4 + d10*x3 + x2)
  
  do j = 1,no
     yk(j)=-d2*(zvar(j)-yr(j))*r(j)+cd
  enddo
  
! yk ok
  !     *****  correct if the relativistic correction is present
  ! FIXME
  if(irel.ne.0) then
     do j=1,no
        zerotmp(j)=yk(j)
     enddo
     
     call relpot(i)
     
     !        Now  vxch(k)=(-z+yr(k))/r(k) + Vx(Slater)
     
     do j=1,no
        yk(j)=zerotmp(j)
     enddo
     
     do j=1,no
        yk(j)=yk(j)+d2*vrel(j)*rr(j)
!     if (mod(j,100)==0 )        print *,'solve 1: j,yk(j)',j,yk(j)
     enddo
  endif
  
  x1 =    ch*p(i,1)*(yk(1)+ed*rr(1))
  x2 =    ch*p(i,2)*(yk(2)+ed*rr(2))
  x3 =    ch*p(i,3)*(yk(3)+ed*rr(3))
  x4 =    ch*p(i,4)*(yk(4)+ed*rr(4))

  do j = 3,nd
     x5 =    ch* p(i,j+2)*(yk(j+2)+ed*rr(j+2))
     x(j) = x(j) - (x5 -d4*(x2 + x4) + d6*x3 +x1)/20.0_PREC
     x1 = x2
     x2 = x3
     x3 = x4
     x4 = x5
  enddo
  rl=dlr(i)+2.5d0
  x(2) = r(2)**rl*(x(5)/r(5)**rl-d3*(x(4)/r(4)**rl - x(3)/r(3)**rl))
  
  !     determine lower bound on the energy parameter
  
  do jj = 15,nd
!  do jj = 50,nd
     j = no - jj
     if (yk(j) .lt. d0) go to 63
  enddo
  
  write (ouc,12) nd
12 format(10x,'potential function too small - 2r*(z-y)<(l+.5)**2)',5x,i4)
  stop
  
63 continue
  em = -yk(j)/rr(j)
!  em = -abs(yk(j))/rr(j)
  fm = em
  
  !     *****   determine diagonal energy parameter
  
  ! FIXME
  !     negative value of e(i,i) indicates that in the first iteration
  !     this parameter is taken from the dump (comp. wavefn)
  
  if(e(i,i).lt.0.d0) then
     ed=-e(i,i)
     e(i,i)=ed
     goto 500
  endif
  
  f1 = d0
  c11 = d0
  m = mmin(maxv(i),no-ione)
  do j = 2,m
     fnum = p(i,j+1) - p(i,j) - p(i,j) + p(i,j-1) -ch*(yk(j+1)*p(i,j+1) + d10*yk(j)*p(i,j) + yk(j-1)*p(i,j-1))-x(j)
     del1 = rr(j+1)*p(i,j+1) + d10*rr(j)*p(i,j) + rr(j-1)*p(i,j-1)
     f1 = f1 +p(i,j)*fnum
     c11 = c11 + p(i,j)*del1
  enddo
2 ed = f1/(c11*ch)

500 continue
  
  if(ed .gt. em) go to 19
  
  !     ***** error message and energy adjustment for an energy parameter
  !     ***** too small for the range of the function
  
  write (ouc,24) ed
24 format(10x,5hed = ,f10.6,36h; adjusted to allowed minimum energy )
  ed = em
  if ( abs(fm - e(i,i)) .gt. 1.d-6 ) go to 19

!  if ( abs(fm - e(i,i)) .gt. 1.e-9_PREC ) go to 19


  write (ouc,64) el(i)
64 format(//10x,14hiteration for ,a3,24h may be converging to a ,18 hcontinuum function/10x, &
        39 hcheck that e(core)-e(total) is positive )
  
  !     *****  check if upper bound is correct
  
19 if (d10*ed .lt. eu) go to 18
  eu = d10*ed
  fu = eu
18 continue
  azd = az(i)

17 do j=1,no
     yr(j) = (yk(j) + ed*rr(j))*ch
     zerotmp(j) = d0
  enddo
  
  !     *****  search for the point at which yr becomes positive
  
  call search(nj,i)
  
  !     *****  compute starting values from series expansion
  
  if (irel.ne.0) then 
     call start(i,v,p1x,p2x)
     hq(1)=p1x
     hq(2)=p2x
  else
     !         b3 = (v + v + ed - (z/fn)**2)/c
     do j = 1,2
        b3 = (v + v + ed - (zvar(j)/fn)**2)/c
        b4 = zvar(j)*(fl+d1+d1/d3)/((fl+d1)*(fl+d2))
        cn = (d2*zvar(j)/fn)**dble(l(i) +1)
        ! FIXME zvar
        !            hw  = hwf(n(i),l(i),z,r(j))/cn
        hw   = hwf(n(i),l(i),zvar(j),r(j))/cn
        hq(j)= azd*(hw + r(j)**dble(l(i)+3)*b3*(d1-r(j)*b4))/r2(j)
     enddo
  endif
  
  !     *****  obtain homogeneous solution


  call nmrvs(nj,delh,mh,hq,zerotmp)

!  print *,'solve: homogenous solution i,nj,delh,mh,hq(1)',i,nj,delh,mh,hq(1)

  pde(1) = hq(1) + xy/c
  pde(2) = hq(2) + xp/c
  
  !     *****  obtain particular solution
  
  call nmrvs(nj,del1,m1,pde,x)
!  print *,'solve: particular solution i,nj,del1,m1,pde(nj)',i,nj,del1,m1,pde(nj)

  !     *****  determine the energy adjustment required for a solution with
  !     *****  given a0
  
  m = mmax(m1,mh)
  pnorm = d0
  do j = 1,m
     pnorm = pnorm + rr(j)*hq(j)*pde(j)
  enddo
  y1 = pde(nj-1)
  y2 = pde(nj)
  y3 = pde(nj+1)
  delta = y2 - y1 + y2 - y3 +yr(nj-1)*y1 + d10*yr(nj)*y2 + yr(nj+1)*y3 + x(nj)
  deltae = hq(nj)*delta/(h*h*pnorm)
  pp = -del1/delh
  !     *****  match at the join for a solution of the differential equation
  
  do j = 1,no
     pde(j)   = pde(j) + pp*hq(j)
  enddo
  
  !     ***** if the equations appear to be nearly singular, solve the
  !     ***** variational equations
  
150 if (kk .ne. 2) return
  
149 x1 = p(i,1)*rr(1)
  x2 = p(i,2)*rr(2)
  p2(1) = x1/c
  p2(2) = x2/c
  do j = 3,no
     x3 = p(i,j)*rr(j)
     xxsolve(j-1) = (d10*x2 + x1 + x3)*ch
     x1 = x2
     x2 = x3
  enddo
  
  call nmrvs(nj,del2,m2,p2,xxsolve)
  
  aa = -del2/delh
  m = mmax(m,m2)
  do j = 1,no
     p2(j) = p2(j) + aa*hq(j)
  enddo
  
  a11 = quad(i,m,p2,p2)
  b11 = quad(i,m,pde,p2)
  c11 = quad(i,m,pde,pde) - d1
  disc = b11*b11 - a11*c11
  if ( disc .lt. d0 ) go to 70
  de1 = -(b11+sqrt(disc))/a11
  de2 = c11/a11/de1
  if( pde(3)+de1*p2(3) .lt. d0) de1 = de2
  go to 71
  
70 de1 = c11/a11
  
71 do j = 1,no
     pde(j) =pde(j) + de1*p2(j)
  enddo
  pp = pp + de1*aa

end subroutine solve
