! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     This routine reads 'grid' card and extablishes parameters of the
! *     current grid
! *
! *****
subroutine setgrid(igrid)
  use global
  use card
  use params
  use relativity
  use wave

  implicit none
  integer :: igrid,irmax,itmp
  real (PREC) :: ftmp,rhomax

  if (igrid.eq.0) then
     
     !        set the default value of grid points 
     no=1500
!        the starting point in rho variable
     rho=-6.0_PREC
     !        and the step size in rho 
     h  =d1/d16/d2/d2
     
     h3=h/d3
     h1=d2*h3
     ch=h*h/d12
     eh=exp(-h)
     
     rmax=0.0_PREC
  else
     
     irmax=0
     call inInt(itmp)
     if (itmp.ne.inIntExit) then 
        no=itmp
        ftmp=0.0_PREC
        call inFloat(ftmp)
        if (ftmp.lt.0.0_PREC) then 
           rho=ftmp
           ftmp=0.0_PREC
           call inFloat(ftmp)
           if (ftmp.ne.0.0_PREC) then 
              rmax=ftmp
              irmax=1
           endif
        endif
     endif
     
     if (no.gt.maxno) then
        write(*,*) 'Error: too many grid points'
        stop 'setgrid'
     endif
     rhomax=rho+dble(no-1)*h
     if (irmax.eq.0) then
        !           calculate the extent of the grid in r variable
        rmax=exp(rhomax)/z
     else
        !           recalculate the step size if rmax is given
        rhomax=log(z*rmax)
        h=(rhomax-rho)/dble(no-1)
     endif
     
     h3=h/d3
     h1=d2*h3
     ch=h*h/d12
     eh=exp(-h)
  endif
  
end subroutine setgrid


