! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     Set some constants.
! *
! *****
subroutine setconst
  use global
  
  implicit none
  integer :: i,i4tmp1,i8tmp1,i8tmp2,lengthint,lengthfp
  real (PREC) :: o

  !      velocity of light
  cvel=137.0359895_PREC
  
  !  pi from b!  -l
  !     scale=32
  !     a(1)*4=           3.14159265358979323846264338327948
  !     scale=64
  !     a(1)*4=           3.14159265358979323846264338327950
  
  pii=atan(one)*four
  
  !   DLAMCH determines double precision machine parameters: 
  !   for the argument 'e' it is the relative machine precision
  
  !       precis=dlamch('e')

  precis=one
  do i=1,10000
     precis=precis/two
     o=one+precis
     if ( o.eq.one ) goto 100
  enddo
100 continue
  
  !      Warning!
  
  !      Precision calculated by the code below depends on compiler
  !      optimization flags used. This routine must be compiled with the
  !      minimum optimization on x86 systems to avoid reporting precision
  !      of the extended IEEE 754 arithmetic.
  
  !      t=one
  !      do i=1,10000
  !      t=t/two
  !      o=one+t
  !      if ( o.eq.one) goto 100
  !      enddo
  !      precis=t
  
  !      set default lengths of integer and real constants and variables used
  
  i8tmp1=2**30
  i8tmp2=100000*i8tmp1
  i4tmp1=i8tmp2
  if (i4tmp1.eq.0) then
     lengthint=4
  else
     lengthint=8
  endif
  
  if (precis.gt.1e-20) then
     lengthfp =8
  else
     lengthfp =16
  endif
  
end subroutine setconst
