! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The rinputd subroutine processes input data
! *
! *****
subroutine rinputd (acfg,scftol,cfgtol,print1,new)
  use global
  use card
  use params
  use relativity
  use wave

  implicit none
  logical*1 :: ld,print1
  character*8 :: atmp,clabel

  integer :: i,ilf,inzero,izz1,itmp,new,nsigdig
  real (PREC) :: acfg,scftol,cfgtol,ftmp

  integer, dimension(100) :: idtmp

500 continue
  ilabel=ilabel+1
  ilf=0
  call inCard
  call inStr(clabel)
  call lowcase(clabel,8)
  
  if (clabel.eq.'inout') then
     ilf=1
     if (iatom.eq.1) then
        write(*,2000)
2000    format('Error: wrong order of input data cards')
        stop 'rinput'
     endif
     
     !        Read unit numbers for input and output files containing initial
     !        and final orbitals, respectively. Two additional optional
     !        values can be used to obtain F and G integrals (oud) and energy
     !        matrix (ouh). By default oud=ouh=0
     
     !        If inf/ouf is set to zero no orbitals are read/written.
     
     
     call inInt(iuf)
     call inInt(ouf)
     call inInt(itmp)
     if (itmp.ne.inIntExit) then
        oud=itmp
        call inInt(itmp)
        if (itmp.ne.inIntExit) then
           ouh=itmp
        endif
     endif
  endif
  
  if (clabel.eq.'out2dhf') then
     ilf=1
     
     !        If unit number ouf2dhf is non-zero configuration information and
     !        final orbitals are written in a format suitable for 2D HF program
     
     ouf2dhf=0
     call inInt(ouf2dhf)
  endif
  
  
  !     read 'grid' card
  if (clabel.eq.'grid') then
     ilf=1
     !        recalculate grid parameters
     call setgrid(ione)
     !        ib = nwf - nit + 1
     nd = no - 2
  endif
  
  
  if (clabel.eq.'atom') then
     ilf=1
     if (iatom.eq.2) then
        write(*,2000)
        stop 'rinput'
     endif
     iatom=1
     !           read 'atom', 'electron' and 'integral' cards            
     call data(new)
  endif

  !        read 'scf' card
  if (clabel.eq.'scf') then
     ilf=1
     call inInt(itmp)
     if (itmp.ne.inIntExit) then
        nsigdig=itmp
        scftol=10.0_PREC**nsigdig
        call inInt(itmp)
        if (itmp.ne.inIntExit) then
           nscf=itmp
           call inStr(clabel)
           call lowcase(clabel,8)
           if     (clabel.eq.'f') then
              omit=.false.
           elseif (clabel.eq.'t') then
              omit=.true.
           endif
        endif
     endif
  endif
  
  !        read 'mcscf' card
  if (clabel.eq.'mcscf') then
     ilf=1
     call inInt(itmp)
     if (itmp.ne.inIntExit) then
        nsigdig=itmp
        cfgtol=10.0_PREC**nsigdig
        call inFloat(ftmp)
        if (ftmp.ne.0.0_PREC) then
           acfg=ftmp
           call inStr(clabel)
           call lowcase(clabel,8)
           if     (clabel.eq.'f') then
              ld=.false.
           elseif (clabel.eq.'t') then
              ld=.true.
           else
              goto 500 
           endif
           call inStr(clabel)
           call lowcase(clabel,8)
           if     (clabel.eq.'f') then
              ortho=.false.
           elseif (clabel.eq.'t') then
              ortho=.true.
           else 
              goto 500
           endif
           call inInt(itmp)
           if (itmp.ne.inIntExit) then
              new=itmp
           endif
        endif
     endif
  endif
  
  
  if (clabel.eq.'alpha') then
     call inFloat(ftmp)
     if (ftmp.ne.0.0_PREC) then
        xalpha=ftmp
     endif
     ilf=1
  endif
  
  if (clabel.eq.'gauss') then
     call inFloat(ftmp)
     if (ftmp.ne.0.0_PREC) then
        izz1=nint(z)
        atweight(izz1)=ftmp
     endif
     ilf=1
     igauss=1
     
  endif
  
  if (clabel.eq.'fermi') then
     ilf=1
     ifermi=1
     call inFloat(ftmp)
     if (ftmp.ne.0.0_PREC) then
        izz1=nint(z)
        atweight(izz1)=ftmp
     endif
  endif
  
  !        read 'rel' and 'qpot' card defining the type of a
  !        quasirelativistic correction
  
  if (clabel.eq.'xpot') then
     ilf=1
     call dataxpot()
  endif
  
  if (clabel.eq.'qpot') then
     ilf=1
     call dataqrpot()
  endif
  
  if (clabel.eq.'rel') then
     ilf=1
     irel=1
     call datarel()
     !           next=2
  endif
  
  if (clabel.eq.'print1') then
     ilf=1
     print1=.true.
  endif
  
  
  !       read 'debug' card 
  if (clabel.eq.'debug') then
     ilf=1
     inzero=0
     do i=1,100
        call inInt(idtmp(i))
        if (idtmp(i).gt.0) then
           inzero=inzero+1
           idbg(idtmp(i))=1
        endif
     enddo
  endif
  
  !     next = -1 stop
  !     next =  0 continue: another case with new initial functions
  !     next =  1 continue: a new case with scaled orbitals as a source of initial functions
  !     next =  2 continue a previous case with (some of) relativistic parameters changed 
  
  if (clabel.eq.'cont') then
     ilf=1
     call inStr(atmp)
     if (atmp.eq.'new') then
        next=0
     endif
     
     if (atmp.eq.'scaled') then
        next=1
     endif
     
     if (atmp.eq.'rel') then
        next=2
     endif
     return
  endif
  
  if (clabel.eq.'stop'.or.clabel.eq.'end') then
     ilf=1
     next=-1
     return
  endif
  
  if (ilf.eq.0) then
     write(*,*) 'Error: unknown label found'
     call prtlabel
     stop 'rinput'
  endif
  if (ilabel.lt.1000) goto 500
  
end subroutine rinputd
