! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     This routine calculates the potential function to be used in a
! *     quasirelativistic correction, its asymptotic form near the origin
! *     and the QR correction itself.
! *
! *****
subroutine relpot(i)
  use global
  use relativity

  implicit none
  integer :: i
  !     The potential used in a quasirelativistic correction consists of
  !     the nuclear, the Coulomb and the local exchange (Slater) potentials 
  call ykdft(i)
  
  !     The quasirelativistic potential modifies solutions of the Fock
  !     equations. Its asymptotic behaviour near the origin is needed to
  !     provide correct staring values for the solutions. It has also to
  !     be acounted for when evaluating integrals since integration over
  !     [0..rho] region is treated analytically.
  
  call gencoeff(i)
  
  go to (10,20,30,40),iqpot
  
  !     Cowan-Griffin correction
10 call qpotcg(i)
  return
  
  !     Wood-Boring correction
20 continue
  call qpotwb(i)
  return
  
  !     Barthelat et al. correction
30 call qpotbpd(i)
  return
  
  !     Karwowski-Klobukowski correction
40 call qpotkk(i)
  
end subroutine relpot
