! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The relmesg subroutine inserts into the output information about a
! *     type of quasirelativistic potential selected, the state and the
! *     nucleus charge distribution model
! *
! *****
subroutine relmesg()
  use global
  use params
  use relativity
  use wave

  implicit none
  integer :: izz1
  real (PREC) :: sf
  
  if (     iqpot.eq.1) then
     write(ouc,91)
91   format(/, 9x,'HF + Cowan-Griffin correction')
     
  elseif (iqpot.eq.2) then
     write(ouc,92)
92   format(/, 9x,'HF + Wood-Boring correction')
     
  elseif (iqpot.eq.3) then
     write(ouc,93)
93   format(/, 9x,'HF + Barthelat et al. correction')
     
  elseif (iqpot.eq.4) then
     write(ouc,94)
94   format(/, 9x,'HF + Karwowski-Klobukowski correction')
  else
     write(ouc,*) 'Error: incorrect value of relativistic correction'
     stop 'dataqr'
  endif
  
  iupd=istate
  !      if (istate.eq.-1) iupd=1
  !      if (istate.eq. 1) iupd=2
  
  !     light velocity scaling factor
  sf=cveldamp/cvel
  
  if(istate) 33,31,32
31 write(ouc,75) sf,cvel
75 format(16x,'  J = 0         c = ',f10.6,' *',f12.7)
  go to 35
32 write(ouc,76) sf,cvel
76 format(16x,'  J = l + 1/2   c = ',f10.6,' *',f12.7)
  go to 35
33 write(ouc,77) sf,cvel
77 format(16x,'  J = l - 1/2   c = ',f10.6,' *',f12.7)
  
35 continue
  
  if (ixpot.eq.1) then
     write(ouc,'(/9x,"local exchange: lda (alpha = ",f10.7")")') xalpha

  elseif (ixpot.eq.2) then
     write(ouc,'(/9x,"local exchange: cowan1 (alpha = ",f10.7")")') xalpha
  elseif (ixpot.eq.3) then
     write(ouc,'(/9x,"local exchange: cowan2 (alpha = ",f10.7")")') xalpha
  endif
  
  if (igauss.ne.0) then
     izz1=nint(z)
     write(ouc,56) atweight(izz1) 
56   format(/9x,"finite nucleus: Gauss nuclear charge distribution"/,25x, "atomic mass = ",d16.10)
  elseif (ifermi.ne.0) then
     izz1=nint(z)
     write(ouc,57) atweight(izz1) 
57   format(/9x,"finite nucleus: Fermi nuclear charge distribution"/,25x, "atomic mass = ",d16.10)
     stop "Error: Fermi model is not yet supported"
  endif
  
end subroutine relmesg
