! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *	quadr integrates p(i)*p(j)*r**kk by simpson's rule
! *
! *****
function quadr(i,j,kk)
  use global
  use params
  use relativity
  use wave

  implicit none
  integer :: i,j,jj,jp,k,kk,m
  real (PREC) :: alpha,bi,bj,d,den,dli,dlj,quadr,zri,zrj
  integer, external :: mmin
  
  k = kk + 2
  dli=dlr(i)
  dlj=dlr(j)
  den=dli+dlj+d1+k
  zri=zrl(i)
  zrj=zrl(j)
  bi=(p(i,4)/(az(i)*r2(4)*r(4)**dli)-d1+zri*r(4)/(dli+d1))/rr(4)
  bj=(p(j,4)/(az(j)*r2(4)*r(4)**dlj)-d1+zrj*r(4)/(dlj+d1))/rr(4)
  alpha=(zri/(dli+d1)+zrj/(dlj+d1))*r(1)
  d=p(i,1)*p(j,1)*r(1)**k*((d1+alpha*(alpha+d1)/(den+d1)-d2*(bi+bj+zri*zrj/((dli+d1)*(dlj+d1))) &
       *rr(1)/(den+d2))/(den*h1)+d5)
  m = mmin(maxv(i),maxv(j)) - 1
  
  do jj = 2,m,2
     jp = jj + 1
     d= d + d2*p(i,jj)*p(j,jj)*r(jj)**k+p(i,jp)*p(j,jp)*r(jp)**k
  enddo
  quadr = d*h1

end function quadr
