! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The qpotwb subroutine fills for orbital i the vrel array with the
! *     values of the quasirelativistic correction due to J.H.Wood and
! *     A.M.Boring (Phys.Rev. B18, 2701 (1978))
! *
! *****
subroutine qpotwb(i)
  use global
  use params
  use relativity
  use state
  use wave

  implicit none
  integer :: i,j
  real (PREC) :: a1,a2,dercuttoff,dli,ee,p11,p22,rt,rt2,vv,xk,zt
  real (PREC), external :: bb,v
  real (PREC), external :: zvar
  real (PREC), dimension(maxno) :: a,ar,arr,pp
  equivalence (a(1),arr(1))

  !     squeeze too large derivatives
!  parameter (dercuttoff=1.0e6_PREC)    ! ok for At
  parameter (dercuttoff=1.0e18_PREC)    ! ok for Au
  
  if (iqpot.ne.2) then
     write(*,*) 'Error: incorrect qusirelativistic potential'
     stop 'qpotwb'
  endif
  
  zt=zvar(i)
  ee=-d5*e(i,i)
  rt=cvel/cveldamp
  rt2=rt*rt
  
  if     (iupd.eq. 0) then
     xk=-d1
  elseif (iupd.eq. 1) then
     xk=-l(i)-d1
  elseif (iupd.eq.-1) then
     xk=l(i)
  endif
  
54 if(qc(i,1).eq.d4*l(i)+d2) xk=-d1
  
  if(iupd.eq.0.and.l(i).ne.0) xk=-d1
  
  dlr(i)=d5*(sqrt((d1-rt)*(d1-rt)+d4*(l(i)*(l(i)+d1)-fsc2*zt*zt-rt*xk))-(d1+rt))

  qm2(i)=-d5*(fsc2*zt*zt+rt2*(dlr(i)+d1+xk))
  
  do j=1,no
     pp(j)=p(i,j)
     a(j)=vxch(j)/r2(j)
  enddo
  
  call diffs(a,ar,ione)
  
  do j=1,no
     ar(j)=(d5*a(j)+ar(j))/r2(j)
  enddo
  
  call diffs(pp,arr,ione)

  do j=1,no
     if (abs(pp(j)).lt.precis) go to 15
     if(abs(arr(j)/pp(j)).lt.dercuttoff) go to 14
15   continue
     if (j.eq.1) then
        arr(j)=d0
     else
        arr(j)=arr(j-1)
     endif
     go to 13
     
14   continue
     arr(j)=arr(j)/pp(j)+d5
     
13   continue
     vrel(j)=-d5*fsc2*((ee-vxch(j))*(ee-vxch(j))+d5*bb(i,j)*ar(j)*(arr(j)+xk)/r(j))
!!     print *,'qpotwb: ',j,vxch(j),ar(j),arr(j),vrel(j)
  enddo
  
  !   expansion coefficients of functions p(r)*sqrt(r) and b
 
  dli=dlr(i)+d1
  p11=-zrl(i)/dli
  p22=(zrl(i)*zrl(i)+dli*(-ee+vv+q0(i)))/(dli*(d2*dli+d1))
  a1=-(ee+d2/fsc2)/zt
  a2=a1*a1+z1/zt
  dli=dli+xk
  
  q0(i)=-d5*(fsc2*(ee*ee-zt*z1*d2)+rt2*((d2*p22-p11*p11)+a1*p11+(a2+z1/zt)*dli))
  qm1(i)=-fsc2*ee*zt-d5*rt2*(p11+a1*dli)
  
  zrl(i)=zt-qm1(i)
  
  if(idbg(20).ne.0) then
     write(ouc,*) 'qpotwb'
     write(ouc,*) 'qm2,qm1,q0',qm2(i),qm1(i),q0(i)
     write(ouc,*) 'ee*ee,zt*z1*d2',ee*ee,zt*z1*d2
     stop
  endif
end subroutine qpotwb
