! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The qpotkk subroutine calculates a quasirelativistic correction
! *     due to Karwowski and Klobukowski
! *
! *****
subroutine qpotkk(i)
  use global
  use params
  use relativity
  use state
  use wave

  implicit none
  integer :: i,j
  real (PREC) :: ax,ee,xk,xx,zt 
!  integer, external :: 
  real (PREC), external :: zvar
  real (PREC), dimension(maxno) :: a,ar

  if (iqpot.ne.4) then
     write(*,*) 'Error: incorrect qusirelativistic potential'
     stop 'qpotkk'
  endif
  
  zt=zvar(i)
  ee=-d5*e(i,i)
  
  
  if     (iupd.eq. 0) then
     xk=-d1
  elseif (iupd.eq. 1) then
     xk=-l(i)-d1
  elseif (iupd.eq.-1) then
     xk=l(i)
  endif
  
54 continue
  
  if(qc(i,1).eq.d4*l(i)+d2.and.l(i).ne.0) then
     xx=l(i)*l(i)*(d1-sqrt(d1-fsc2*zt*zt/(l(i)*l(i))))-(l(i)+1)**2*(d1-sqrt(d1-fsc2*zt*zt/(l(i)+1)**2))
     xx=xx/(d2*l(i)+d1)
     xk=d1
  endif
  if(l(i).eq.0)  xk=-d1
  
  xx=d1-sqrt(d1-fsc2*zt*zt/(xk*xk))
  
  do j=1,no
     vrel(j)=-d5*fsc2*((ee-vxch(j))**2+xx*xk/rr(j)/fsc2)
  enddo

  q0(i)=(zt*z1-ee*ee*d5)*fsc2
  
  qm1(i)=-ee*zt*fsc2
  qm2(i)=-d5*(zt*zt*fsc2+xk*xx)
  
  zrl(i)=zt-qm1(i)
  ax=(l(i)+d5)*(l(i)+d5)+d2*qm2(i)
  if(ax.gt.0d0) then 
     dlr(i)=-d5+sqrt(ax)
  else
     dlr(i)=-d5
  endif

  ! FIXME
  if(idbg(30).ne.0) then
     write(ouc,*) 'qpotkk'
     write(ouc,*) 'qm2,qm1,qm0, zrl,dlr',qm2(i),qm1(i),q0(i),zrl(i),dlr(i)
  endif
  
end subroutine qpotkk
