! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The potllda subroutine fills for orbital i the vdft array with the
! *     values of the Slater local exchange potential. It is assumed that
! *     only one configuration contributes to the total density and that
! *     the number of electrons with up and down spin matches
! *
! *****
subroutine potllda(i)
  use global
  use params
  use relativity
  use state

  implicit none
  integer :: i,j,k
  real (PREC) :: const13,const23,const34,rhot,rhotp,fdftpot,qcc,qccp
!  integer, external :: 
!  real (PREC), external :: 


  parameter (const13=1.0_PREC/3.0_PREC,const23=2.0_PREC/3.0_PREC,const34=3.0_PREC/4.0_PREC)

  qccp=d2
  if (qc(i,1).lt.qccp) qccp=qc(i,1)
  
  !    fdftpot=-xalpha*three/two*(three/pii)**const13/two**(const23)
  fdftpot=-xalpha*three/two*(three/pii)**const13
  do k=1,no
     rhot=d0
     do j=1,nwf
        qcc=qc(j,1)
        rhot=rhot+qcc*p(j,k)*p(j,k)
     enddo
     rhotp=abs(rhot-qccp*p(i,k)*p(i,k))
     vdft(k)=fdftpot*rhotp**const13
  enddo

end subroutine potllda
