! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The potlcg2 subroutine fills for orbital i the vdft array with
! *     the values of the Slater local exchange potential as proposed by
! *     Cowan (Phys. Rev. 163, 54 (1967), eq.14, f=1). It is assumed that only one
! *     configuration contributes to the total density.
! *
! *****
subroutine potlcg2(i)
  use global
  use params
  use relativity
  use state

  implicit none
  integer :: i,j,k
  real (PREC) :: const13,ck0,ck1,rhot,rhotp,fdftpot,qcc,qccp
!  integer, external :: 
!  real (PREC), external :: 

  parameter (const13=1.0_PREC/3.0_PREC, ck0=1.0_PREC/3.0_PREC)
  
  
  qccp=d2
  if (qc(i,1).lt.qccp) qccp=qc(i,1)
  
  ck1=d1/xalpha
  
  fdftpot=-ck1*two*(three/pii)**const13
  
  do k=1,no
     rhot=d0
     do j=1,nwf
        qcc=qc(j,1)
        rhot=rhot+qcc*p(j,k)*p(j,k)
     enddo
     rhotp=abs(rhot-qccp*p(i,k)*p(i,k))
     if (rhot.gt.0d0) then
        vdft(k)=fdftpot*(rhotp/(rhotp+d5/(n(i)-l(i))))*(rhotp/rhot)*rhot**const13
     else
        vdft(k)=d0
     endif
  enddo
  
end subroutine potlcg2
