! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The potlcg1 subroutine fills for orbital i the vdft array with the
! *     values of the Slater local exchange potential as proposed by Cowan
! *     (Phys. Rev. 163, 54 (1967), eq.12). It is assumed that only one
! *     configuration contributes to the total density.
! *
! *****
subroutine potlcg1(i)
  use global
  use params
  use relativity
  use state

  implicit none
  integer :: i,j,k
  real (PREC) :: const13,ck0,ck1,rhot,rhotp,fdftpot,qcc,qccp

  parameter (const13=1.0_PREC/3.0_PREC, ck0=1.0_PREC/3.0_PREC)


  qccp=d2
  if (qc(i,1).lt.qccp) qccp=qc(i,1)
  
  ck1=d1/xalpha
  
  fdftpot=-ck1*two*(three/pii)**const13
  
  do k=1,no
     rhot=d0
     do j=1,nwf
        qcc=qc(j,1)
        rhot=rhot+qcc*p(j,k)*p(j,k)
!        if ( mod(k,100)==0 ) print *,'potlcg1: k,j,rhot,p',k,j,rhot,p(j,k)
     enddo
     rhotp=abs(rhot-qccp*p(i,k)*p(i,k))
     !        vdft(k)=fdftpot*(rhotp/rhot)**ck0*rhot**const13
     !        since ck0=const13
     vdft(k)=fdftpot*(rhotp)**const13
!     if (mod(k,100)==0 ) print *,'potlcg1: k,rhot,rhotp,p(,vdft',k,rhot,rhotp,p(i,k),vdft(k)
  enddo

end subroutine potlcg1
