! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *	The output subroutine prints the set of functions P_i(r)
! *	involved in the SCF iterations. These functions together with r
! *	values and some additional parameters may also be written into a
! *	separate file for later use by the 2DHF program
! *
! *****
subroutine output(print1)
  use global
  use ode
  use params
  use relativity
  use state
  use wave

  implicit none
  logical*1 :: print1
!  integer :: i,ij,j,jf,jj,k,kk,lm,ml,mu,mx,mxmax
  integer :: i,ij,j,jf,jj,k,lm,ml,mu,mx,mxmax
  real (PREC) :: t
  real (PREC), dimension(8) :: out
  real (PREC), dimension(maxno) :: px11
  integer, external :: mmax,mmin
  real (PREC), external :: quadr

  if ( .not. print ) go to 30
  
!     *****  print radial functions, 7 per page

  ml = ib
2 mu = mmin(ml+7,nwf)
  i = mu - ml + 1
  mx = 0
  do j = ml,mu
     mx = mmax(mx,maxv(j))
  enddo
  write (ouc,5) atom,term,(el(j),j=ml,mu)
5 format(/1h1,9x,19hwave functions for ,2a6//10x,1hr,8(10x,a3))
  
  
  k= 0
  kk = 0
  do j = 1,mx
     do jj = ml,mu
        ij = jj - ml + 1
        out(ij) = p(jj,j)*r2(j)
     enddo
     k = k+1
     if (k .le. 10) go to 6
     k = 1
     kk = kk+1
     if (kk .lt. 5) go to 21
     kk = 0
     write (ouc,23)
23   format(1h1//)
     go to 6
21   write (ouc,8)
8    format(1x)
6    write (ouc,10) r(j),(out(jj),jj=1,i)
  enddo
  
10 format(d13.5,d15.6,7d13.6)
  do j = ml,mu
     ij = j - ml + 1
     out(ij) = dpm(j)
  enddo
  
  write (ouc,16) (out(j),j=1,i)
16 format(4x,10hmax. diff. ,d15.7,7d13.7)
  ml = ml+8
  if (ml .le. nwf) go to 2
  if( nwf .le. 1 ) go to 30
  
  !     *****  print orthogonality integrals
  
  write (ouc,11) atom,term
11 format(////10x,33horthogonality integrals for atom ,a6,6h term ,a6 //20x, 4h(nl),3x,4h(nl),7x,8hintegral //)
  lm = ib
  ml = mmax(itwo,lm)
  do i = ml,nwf
     jf = i - 1
     do j = 1,jf
        if (l(i) .ne. l(j)) go to 13
        t = quadr(i,j,izero)
        write (ouc,17) el(i),el(j),t
17      format(21x,a3,4x,a3,f15.8)
13      continue
     enddo
  enddo
  
30 continue
  
  !     output functions on unit ouf for future input
  if (ouf .ne. 0) then
     open(ouf,status='unknown',form='formatted')
     do i = ib,nwf
        mx = maxv(i)
        write(ouf,3) atom,term,z,no,rho,rmax
!        write(*,3) atom,term,z,no,rho,rmax
        write(ouf,4) el(i),mx,e(i,i),ek(i),az(i),zrl(i),dlr(i),dpm(i),acc(i)
!        write(*,4)   el(i),mx,e(i,i),ek(i),az(i),zrl(i),dlr(i),dpm(i),acc(i)
        write(ouf,7) (p(i,j),j = 1,no)
!        write(ouf,'(//)') 
        write(ouf,7) (y(i,j),j = 1,no)
        write(ouf,7) (e(i,j),j = 1,nwf)
     enddo
!     write(ouf,7) deltae
     close(ouf)
     
! 4    format(  6h atom ,a6,6h term ,a6,9helectron ,a3,i6,f6.2/4 h e =,1pd22.15,4h i =,1pd22.15,4h az=,1pd22.15, &
!           4hzrl=,1pd22.15,4hdrl=,1pd22.15,1pd22.15)


3    format(' atom= ',a6,' term= ',a6,' z= ',f6.2,' no= ',i6,' rho= ',1pd22.15,' rmax= ',1pd22.15)
4    format(' electron= ',a3,' maxv= ',i6,' e= ',1pd22.15,' ek= ',1pd22.15,' az= ',1pd22.15, &
          ' zrl= ',1pd22.15,' dlr= ',1pd22.15,' dpm= ',1pd22.15,' acc= ',1pd22.15)
!,' em= ',1pd22.15,' au= ',1pd22.15)

!10    format(a7,a6,a7,a6,a11,a3,a7,i6,a4,f6.2/a4,1pd22.15,a5,1pd22.15,a5,1pd22.15, &

7    format(4d22.15)
  endif
  
  !     output functions on unit ouf2dhf in format suitable for the 2D HD program   
  if (ouf2dhf .ne. 0) then
     mxmax=0
     do i=1,nwf
        if (maxv(i).gt.mxmax) mxmax=maxv(i)
     enddo
     
     mxmax=no
     write(ouf2dhf,*) atom,term,z,nwf,mxmax
     write(ouf2dhf,'(2x,20i5)') (n(i),i=ib,nwf)
     write(ouf2dhf,'(2x,20i5)') (l(i),i=ib,nwf)
     write(ouf2dhf,'(3x,20f5.0)') (qc(i,1),i=ib,nwf)
     write(ouf2dhf,'(24x,20d24.16)') (-e(i,i)/2.0,i=ib,nwf)
     do j=1,mxmax
        write(ouf2dhf,'(20d24.16)') r(j),(p(i,j)*r2(j),i=1,nwf)
     enddo
  endif
  
  !     calculate d (p*p)/dz at the nucleus
  
  !      call nuclder
  
end subroutine output


