! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The nmrvs subroutine integrates the equation Y''=F(r)Y+G(r)
! *     outward nj steps by the Numerov method, then applies a tail
! *     procedure for a solution
! *
! *****
subroutine nmrvs(nj,delta,mm,pde,f)
  use global
  use params
  use ode

  implicit none
  integer :: i,ii,j,k,nj,mm
  real (PREC) :: con,g,g1,g2,g3,delta,ratio,y1,y2,y3 

  real (PREC), dimension(maxno) :: pde,f
  real (PREC), dimension(maxno) :: aa,dd

  equivalence (g,g3)

  !  *****  integrate outward to nj+1
  
  y1 = pde(1)
  y2 = pde(2)
  g1 = yr(1)
  g2 = yr(2)
  m = nj + 1

  do i = 3,m
     g3 = yr(i)
!     print *,'nmrvs: 1', i,g1,g2,g3
!     print *,'nmrvs: 1', i,y1,y2,f(i-1)
     y3 = (y2+y2-y1 + (d10*g2*y2 + g1*y1) + f(i-1)) / (d1 - g3)
!     print *,'nmrvs: 2', y3
     if ( abs(y3)>1.0e10_PREC ) then
        write(ouc,'(/,5x,"outward integration failure at ",i5," ... y3 is too large ...",1pe13.6)') i,y3
        stop 'nmrvs'
     endif
     pde(i) = y3
     y1 = y2
     y2 = y3
     g1 = g2
     g2 = g3
  enddo
  delta = y3
  
  !    *****  apply the tail procedure
  
  k = 1
  pde(m) = -(d1 - g1)*y1 + f(m)
  
  aa(1) = d1 - g
  dd(1) = -(d2 + d10*g)
22 ratio = aa(k)/dd(k)
 
  !     if (k .ge. 149 .or. m .eq. nd) go to 23
  !     8/04/05 hardcoded limitations lifted
  
  if (k .ge. nd .or. m .eq. nd) go to 23
  k = k+1
  m = m+1
  g = yr(m)
  aa(k) = d1 - g
  dd(k) = -(d2 + d10*g) - aa(k)*ratio
  pde(m) = -pde(m-1)*ratio + f(m)
!  if (mod(k,25).eq.0) print *,'nmrvs: ', k,m,abs(pde(m))+abs(pde(m-1)), tol
  if (abs(pde(m))+abs(pde(m-1)) .gt. tol .or. k .lt. 9) go to 22
  
20 con =sqrt(eh)*exp(-sqrt(abs(g/ch-0.250_PREC)/rr(m))*(r(m+1)-r(m)))
  
  pde(m) = pde(m)/(dd(k) + con*(d1-yr(m+1)))
  j = m+1
  do i= j,no
     pde(i) = d0
  enddo
  
  do j = 2,k
     i = m-j+1
     ii = k-j+1
     pde(i) = (pde(i)-aa(ii+1)*pde(i+1))/dd(ii)
  enddo
  
  !     *****  set delta = difference of the two solutions at nj+1
  !     *****  mm = number of points in the range of the solution

  delta = delta - pde(i)
  mm = m

  return
  
23 write (ouc,24)
24 format(6x,52hwarning: functions truncated by nmrvs in tail region)
  
  go to 20
end subroutine nmrvs
