! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *	The method controls the process of finding a solution to the
! *	Fock equation for the i-th orbital
! *
! *****
subroutine method(i)
  use global
  use coeffs
  use ode
  use params
  use relativity
  use wave

  implicit none
  logical*1 :: v1,v2,first
  integer :: i,j,nc
  integer, external :: nodec
  real (PREC) :: del,deltaeAdjThresh,edp,fnexp
  real (PREC), external :: emin,hl,zvar

  parameter (deltaeAdjThresh=0.04_PREC,fnexp=2.5_PREC)

!  real (PREC), dimension(maxno) :: p1
!  equivalence (pde(1),p1(1))

  !     *****   'first' must be 'true' the first time solve is called for
  !     *****   potential and exchange to be computed
  !     *****   'one' is set 'true' as soon as an acceptable solution has
  !     *****   been found
  !     *****   'eu' is the upper bound of energy parameter
  !     *****   'em' is the minimum value of the energy parameter

  first=.true.
  fail=.false.
  em= d0
  eu=((z-emin(d5*s(i),d2*s(i)))/n(i))**2
! ToDelete
!  print *,'method: eu', eu,d5*hl(i,i)
  fu=eu
  mk= 0

17 call solve(i,first)

  !     *****   if kk not equal 1, omit the node checking
  
  if (kk.eq.3) go to 51
  
  !     *****   count the number of nodes
  
  nc=nodec(m)

  !     *****   if node count is off by no more than 1 deltae is still
  !     *****   quite large, apply the deltae correction
  
  !  if( abs(nc-node)==1 .and. abs(deltae/ed)>0.02_PREC ) go to 46
  
  ! When quasirelativistic calculations are performed allow for larger values of deltae
  ! before trying to adjust energy to lie between the upper and lower bound.
  ! Should the criterion be orbital energy dependent?
  
  if( abs(nc-node)==1 .and. abs(deltae/ed)> deltaeAdjThresh ) go to 46
  
  !     *****   branch according to whether the node count is too small,
  !     *****   just right, or too large
  
  !  if(nc-node) 8,9,10

  if ( (nc-node)==0 ) then 

     !     *****   the solution has the correct number of nodes
     
     !  Should abs(deltae)/ed be increased when solving HF equations for heavy atoms with
     !  relativistic corrections included? 

!     v2=abs(deltae)/ed.lt.1.e-5_PREC
     v2=abs(deltae)/ed.lt.1.e-3_PREC



     if(pde(1).lt.d0.and..not.v2) go to 46
     if(pde(1).gt.d0) go to 51
     do j=1,no
        pde(j)=-pde(j)
     enddo
     pp=-d2-pp
51   azz=azd*(d1+pp)
     e(i,i)=ed
     return
     
  elseif ( (nc-node)<0 ) then 
     !   *****   the solution has too few nodes
     
     if(pde(1).le.d0) go to 11
     del=d1-ed/eu
     eu=ed
!     if(del.lt. 0.05_PREC) fu=fu*((l(i)+1+nc)/fn)**fnexp
!     if(del.ge. 0.05_PREC) fu=ed*((l(i)+1+nc)/fn)**fnexp
     
!     FIXME jkob 4/04/05
     if(del.lt. .05_PREC) fu=fu*((dlr(i)+1+nc)/fn)**fnexp
     if(del.ge. .05_PREC) fu=ed*((dlr(i)+1+nc)/fn)**fnexp
     
     if(fu.lt.em) fu=d5*(eu+em)
     if(abs(fu-ed).lt. 0.001_PREC) go to 27
     ed=fu
     go to 33
     
     !     *****   try a new value of ed which must lie within the upper and
     !     *****   lower bound
     
11   edp=ed
!     ed=ed*((l(i)+1+nc)/fn)**fnexp
     ed=ed*((dlr(i)+1+nc)/fn)**fnexp
     if(ed.ge.eu) ed=d5*(eu+edp)
     if(ed.le.em) ed=d5*(em+edp)
33   mk=mk+1
     if(eu.le.em) write(ouc,30) em,eu,ed
30   format(6x,48hwarning: difficulty with node counting procedure/ &
          6 x,42hlower bound on ed greater than upper bound/        &
          6x,5hel = ,1pe12.6,7h  eu = ,1pe12.6,7h  ed = ,1pe12.6)
     first= .false.

     if(mk.gt.3*n(i).or.eu-em.lt.fn**(-3)) go to 27
     go to 17
     
     !   *****   the solution has too many nodes
  elseif ( (nc-node)>0 ) then 
     if(pde(1).lt. d0) go to 11
     del=d1-em/ed
     em=ed
!     if(del.lt. .05d0) fm=fm*((l(i)+1+nc)/fn)**fnexp
!     if(del.ge. .05d0) fm=ed*((l(i)+1+nc)/fn)**fnexp

     if(del.lt. .05d0) fm=fm*((dlr(i)+1+nc)/fn)**fnexp
     if(del.ge. .05d0) fm=ed*((dlr(i)+1+nc)/fn)**fnexp

     if(fm.gt.eu) fm= d5*(eu+em)
!     if(abs(fm-ed).lt.0.001_PREC) go to 27
     if(abs(fm-ed).lt.0.001_PREC) go to 27
     ed=fm
     go to 33
  endif
  
  !   *****  d adjust energy to lie between upper and lower bound
  
46  ed=ed-deltae
    if(ed.le.em.or.ed.ge.eu) ed=ed+deltae+deltae
    if(ed.gt.em.and.ed.lt.eu) go to 33
  ed=ed-deltae
  deltae= d5*deltae
  go to 46
  
  !   *****   method was unable to find an acceptable solution
27 write (ouc,28) kk,el(i),nc,nj,ed,em,eu
!  write (ouc,*) kk,el(i),nc,nj,ed,em,eu
28 format(10x,6hmethod,i2,39h unable to solve equation for electron ,  &
        a3/10x,5hnc = ,i5,3x,5hnj = ,i5,3x,5hed = ,1pe13.6,3x,5hel = ,  &
        1pe13.6,3x,5heu = ,1pe13.6)
  fail= .true.
  
end subroutine method
