! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The rpert subroutine determines the effect of a perturbation (in
! *     the form of a rotation of two given orbitals) both on the energy
! *     an on the stationaty condition, due to the presence of a given lk
! *     integral
! *
! *****
subroutine lpert(iin,jin,m)
  use global
  use params
  use rotorb
  use state

  implicit none
  integer :: i,i1,i2,i3,i4,i5,i6,iin,ipw,j,jin,kk,k1,k2,kp,m
  real (PREC) :: ovlap
  real (PREC), external :: hl,quadr,rk

  integer, dimension(6) :: ind
  equivalence (i1,ind(1)),(i2,ind(2)),(i3,ind(3)),(i4,ind(4)),(i5,ind(5)),(i6,ind(6))

  i1 = ili(m)
  i2 = ilj(m)
  j = iin
  i = jin
  ipw = lq(m)
  if (ipw .eq. 0) go to 1
  i5 = ilo(m)
  i6 = jlo(m)
  ovlap = quadr(i5,i6,izero)**ipw
  if ((i5-i)*(i6-i)*(i5-j)*(i6-j) .ne. 0) go to 1
  ezero = .false.
  return
  
1 do kp = 1,2
     di =d0
     dii = d0
     dij = d0
     do k =1,2
        if (ind(k) .ne. i) go to 2
        ind(k) = j
        di = di + hl(i1,i2)
        if (.not. all) go to 3
        do k2 = 1,2
           if (ind(k2) .ne.j) go to 5
           ind(k2) = i
           dij = dij + hl(i1,i2)
           ind(k2) = j
5          if (ind(k2) .ne. i) go to 4
           ind(k2) =j
           dii = dii + hl(i1,i2)
           ind(k2) = i
4          continue
        enddo
3       ind(k) = i
2       continue
     enddo
     
     if (ipw .eq. 0) go to 6
     di = di*ovlap
     dii = dii*ovlap
     dij = dij*ovlap
     
6    if (kp .eq. 2) return
     
     dj =di
     djj =dii
     dji = dij
     i = iin
     j = jin
  enddo
  
end subroutine lpert
