! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     This subroutine initializes various constants and variables
! *
! *****
subroutine init
  use global
  use coeffs
  use params
  use relativity
  use wave

!     i/o channels in use:

!       pi and precis are set in setconst routine
!       data pii,precis /3.1415926535897931159979634685442d0,1.d-14/


  implicit none
  integer :: i,im,j,k
  real (PREC) :: cfgtol,scftol

  !      set velocity of light, pi, etc
  call setconst
  
  cfgtol=0.0_PREC
  scftol=0.0_PREC
  
  !      set commonly used real*8 constants
  
  d0=0.0_PREC
  d1=1.0_PREC
  d2=2.0_PREC
  d3=3.0_PREC
  d4=4.0_PREC
  d5=1.0_PREC/2.0_PREC
  d6=6.0_PREC
  d8=8.0_PREC
  d10=10.0_PREC
  d12=12.0_PREC
  d16=16.0_PREC
  d30=30.0_PREC
  
  !    *****   clear the arrays for the average interactions
  
  do i=1,4
     do j=1,4
        ca(i,j)=0_PREC
     enddo
  enddo
  
  do i=1,5
     do j=1,5
        do k=1,5
           cb(i,j,k)=0_PREC
        enddo
     enddo
  enddo
  
  !    *****   average interactions for equivalent electrons
  
  !    *****   p  -  p
  
  ca(1,1)=2.0_PREC/25.0_PREC
  
  !    *****   d  -  d
  
  ca(2,1)=2.0_PREC/63.0_PREC
  ca(2,2)=2.0_PREC/63.0_PREC
  
  !    *****   f  -  f
  
  ca(3,1)=	4.0_PREC/195.0_PREC
  ca(3,2)=	2.0_PREC/143.0_PREC
  ca(3,3)=100.0_PREC/5577.0_PREC
  
  !    *****   g  -  g
  
  ca(4,1)=	20.0_PREC/	1309.0_PREC
  ca(4,2)= 162.0_PREC/ 17017.0_PREC
  ca(4,3)=	20.0_PREC/	2431.0_PREC
  ca(4,4)=4410.0_PREC/371943.0_PREC
  
  !    *****   average interactions for non-equivalent electrons
  
  !    *****   s  -  ( s, p, d, f, g )
  
  cb(1,1,1)=1.0_PREC/2.0_PREC
  cb(2,1,1)=1.0_PREC/6.0_PREC
  cb(3,1,1)=1.0_PREC/10.0_PREC
  cb(4,1,1)=1.0_PREC/14.0_PREC
  cb(5,1,1)=1.0_PREC/18.0_PREC
  
  !    *****   p  -  ( p, d, f, g )
  
  cb(2,2,1)=1.0_PREC/6.0_PREC
  cb(2,2,2)=1.0_PREC/15.0_PREC
  cb(3,2,1)=1.0_PREC/15.0_PREC
  cb(3,2,2)=3.0_PREC/70.0_PREC
  cb(4,2,1)=3.0_PREC/70.0_PREC
  cb(4,2,2)=2.0_PREC/63.0_PREC
  cb(5,2,1)=2.0_PREC/63.0_PREC
  cb(5,2,2)=5.0_PREC/198.0_PREC
  
  !    *****   d  -  ( d, f, g )
  
  cb(3,3,1)=1.0_PREC/10.0_PREC
  cb(3,3,2)=1.0_PREC/35.0_PREC
  cb(3,3,3)=1.0_PREC/35.0_PREC
  cb(4,3,1)=3.0_PREC/70.0_PREC
  cb(4,3,2)=2.0_PREC/105.0_PREC
  cb(4,3,3)=5.0_PREC/231.0_PREC
  cb(5,3,1)=1.0_PREC/35.0_PREC
  cb(5,3,2)=10.0_PREC/693.0_PREC
  cb(5,3,3)=5.0_PREC/286.0_PREC
  
  !    *****   f  -  ( f, g )
  
  cb(4,4,1)=1.0_PREC/14.0_PREC
  cb(4,4,2)=2.0_PREC/105.0_PREC
  cb(4,4,3)=1.0_PREC/77.0_PREC
  cb(4,4,4)=50.0_PREC/3003.0_PREC
  cb(5,4,1)=2.0_PREC/63.0_PREC
  cb(5,4,2)=1.0_PREC/77.0_PREC
  cb(5,4,3)=10.0_PREC/1001.0_PREC
  cb(5,4,4)=35.0_PREC/2574.0_PREC
  
  !    *****   g  -  ( g )
  
  cb(5,5,1)=1.0_PREC/18.0_PREC
  cb(5,5,2)=10.0_PREC/693.0_PREC
  cb(5,5,3)=9.0_PREC/1001.0_PREC
  cb(5,5,4)=10.0_PREC/1287.0_PREC
  cb(5,5,5)=245.0_PREC/21879.0_PREC
  
  !    *****   symmetrize the array
  
  do i=2,5
     im=i-1
     do j=1,im
        do k=1,4
           cb(j,i,k)=cb(i,j,k)
        enddo
     enddo
  enddo
  
  !      moved from main
  do i=1,20
!     if (iuf==0) dpm(i)=d10
     dpm(i)=d10
     do j=1,20
        if(i.ne.j) e(i,j)=1.d-10
     enddo
  enddo
  
  do i=1,100
     idbg(i)=0
  enddo
  
  return
end subroutine init
