! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     hwf computes a value for an unnormalized hydrogenic function
! *
! *****
function hwf(nn,ll,zz,rt)
  use global
  use params

  implicit none
  integer :: i,k,ll,nn
  real (PREC) :: a,b,c,hwf,pp,rt,xx,zz

  k = nn-ll-1
  pp = d1
  a = d1
  b = k
  c = nn+ ll
  xx = -d2*zz*rt/nn
  
  !  *****  test if underflow may occur, if so set hwf = 0
  
  if ( xx .lt. -180.0_PREC ) then
     hwf = d0
     return
  endif
  
  if ( k<0 ) then
     write(ouc,7) nn,ll,zz,rt
7    format(51h forbidden combination of n and l in hwf subprogram/4 h n =,i4,6h   l = ,i4,6h   z = ,f6.1,6h   r = ,f8.4)
     stop
  elseif (k==0) then
     hwf = pp*exp(xx/d2)*(-xx)**(ll+1)
     return
  elseif (k>0) then
     do i = 1,k
        pp = d1 + a/b*pp/c*xx
        a = a + d1
        b = b - d1
        c = c - d1
     enddo
     hwf = pp*exp(xx/d2)*(-xx)**(ll+1)
  endif
  
end function hwf
