! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     hnorm computes the normalization constant for the hydrogenic
! *     function
! *
! *****
function hnorm(nn,ll,zz)
  use global
  use params
  
  implicit none
  integer :: i,ll,m,nn
  real (PREC) :: a,b,d,hnorm,t,zz

  m = ll + ll + 1
  a = nn + ll
  b = m
  t = a
  d = b
  m = m - 1
  if (m .ne. 0) then
     do i = 1,m
        a = a - d1
        b = b - d1
        t = t*a
        d = d*b
     enddo
  endif
  
  hnorm = sqrt(zz*t)/( nn*d)
  
end function hnorm
