! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     grange computes off-diagonal energy parameters
! *
! *****
subroutine grange
  use global
  use coeffs
  use params
  use relativity
  use rotorb
  use wave

  implicit none
  integer :: i,i1,i2,ii,ip,irow,it,j,j1,j2,jp,jt,k1,k2,k3,k4,kk,kkk,kp,ktt,lm,ni,nii,nnj
  real (PREC) :: c1,c2,cm,dd,den,dm,ov,ovi,ovj,ratio,t
  integer, external :: mmax
  real (PREC), external :: elagr,ekin,hl,quadr

  integer, dimension(4) :: ki,kj,kt
  real (PREC), dimension(4,5) :: aa
  real (PREC), dimension(4) :: cc,xx

  equivalence (i1,ki(1)),(i2,ki(2)),(j1,kj(1)),(j2,kj(2))
  equivalence (aa(1,5),cc(1))

  if (nwf.eq.1.or.ib.gt.nwf) return
  write (ouc,*)
  ii = mmax(2,ib)
  
  do i = ii,nwf
     
     !        *****  when ortho is 'true',check if another orbital with index > i
     !        *****  has the same nl values
     
     if (i.eq.nwf.or..not.ortho) go to 1
     other = .false.
     ip = i+1
     do i2 = ip,nwf
        if (n(i2).eq.n(i).and.l(i2).eq.l(i)) other = .true.
        continue
     enddo
     
     if (other) go to 2
1    il = i-1
     do j = 1,il
        if (n(i).eq.n(j).or.l(i).ne.l(j)) go to 4
        if (a(i,j,ione).eq.0d0.and..not.ortho) go to 4
        ki(1) = i
        kj(1) = j
        ni = 1
        nnj = 1
        if (.not.ortho) go to 6
        
        !           *****  an (i,j) pair constrained by an orthogonality requirement has
        !           *****  been found.  check if another orbital with index > j has the
        !           *****  same nl values.
        
        other = .false.
        jp = j+1
        do j2 = jp,nwf
           if (n(j2).eq.n(j).and.l(j2).eq.l(j)) other = .true.
        enddo
        if (other) go to 4
        
        !           *****  the (i,j) pair has the highest possible indices for the given
        !           *****  set of nl values
        
        !           *****  search for other orbitals with the same nl values
        
        do k =1,nwf
           if (k.eq.i.or.n(k).ne.n(i).or.l(k).ne.l(i)) go to 8
           ni = ni + 1
           ki(ni) = k
           go to 7
8          if (k.eq.j.or.n(k).ne.n(j).or.l(k).ne.l(j)) go to 7
           nnj = nnj + 1
           kj(nnj) = k
7          continue
        enddo
        if (ni*nnj.eq.1) go to 6
        
        !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
        !           *****  one of the nl values has more than one orbital associated with it
!        if (nnj-2) 41,42,30
        if (nnj-2==0) then
        !           *****  now nnj = 2
        
42         if (j1.ge.ib.or.j2.ge.ib) go to 430
        
           !           *****  now nnj = 2 and j1 and j2 are both part of the frozen core
           
           ov = quadr (j1,j2,izero)
           den = d1 - ov**2
           do k = 1,ni
              kk = ki(k)
              if (kk.lt.ib) go to 31
              c1 = hl(kk,j1)-ekin(kk,j1)
              c2 = hl(kk,j2)-ekin(kk,j2)
              e(kk,j1) = (c1-c2*ov)/den
              e(kk,j2) = (c2-c1*ov)/den
              write (ouc,24) el(kk),el(j1),e(kk,j1),el(kk),el(j2),e(kk,j2)
!              write (*,24) el(kk),el(j1),e(kk,j1),el(kk),el(j2),e(kk,j2)
31            continue
           enddo
           go to 4
           
           elseif(nnj-2>0) then
              !           *****  too many orbitals with the same nl values
        
30             write(ouc,23) (ki(k),k=1,ni),(kj(k),k=1,nnj)
23            format(/10x,50 htoo many orbitals with the same nl value..indices,3hare/10x,20i3)
              stop
              
              !           *****  nnj = 2 but with either j1 or j2 not part of the frozen core
              
43            continue
              goto 430

              elseif(nnj-2<0) then
                 !           *****  nnj = 1 but ni .gt. 1
                 
41               if (j1 .ge. ib) go to 430
              !           *****  now nnj = 1 and j1 is part of the frozen core
14            do k = 1,ni
                 kk = ki(k)
                 e(kk,j1) = hl(kk,j1) - ekin(kk,j1)
                 write (ouc,25) el(kk),el(j1),e(kk,j1)
              enddo
25            format(10x,2he(,2a3,4h) = ,f10.6)
              go to 4
           endif

!!!!!!!!!!!!!!!!!!! 43 block 

430        continue
              if (ni.gt.2) then 
                 write(ouc,23) (ki(k),k=1,ni),(kj(k),k=1,nnj)
                 stop
              endif
              
              !           *****  if necessary, interchange the two groups so that ni .le. nnj
              
              if (ni.le.nnj) go to 15
              do k = 1,ni
                 kt(k) = ki(k)
              enddo
              nii = ni
              do k = 1,nnj
                 ki(k) = kj(k)
              enddo
              ni = nnj
              do k = 1,nii
                 kj(k) = kt(k)
              enddo
              nnj = nii
              
              !           *****  set up the system of equations for up to 4 off-diagonal
              !           *****  energy parameters
              
15            do k = 1,4
                 xx(k) = d0
                 do kk = 1,5
                    aa(k,kk) = d0
                 enddo
              enddo
              if (ni.eq.1) i2 = 0
              k1 = 1
              k2 = 2
              k3 = 3
              k4 = 4
              irow = 1
              ovi = d0
              if (i2.ne.0) ovi = quadr(i1,i2,izero)
              ovj = quadr(j1,j2,izero)
              do k = 1,2
                 do kk = 1,2
                    if (i1.eq.0) go to 55
                    if (i1.lt.ib) go to 52
                    
                    !                 *****  now i1 .ge. ib
                    
                    if (j1 .lt. ib) go to 53
                    
                    !                 *****  now i1 and j1 .ge. ib
                    
                    cc(irow) = hl(i1,j1)-ekin(i1,j1) + hl(j1,i1) - ekin(j1,i1)
                    aa(irow,k1) = d1 + sum(i1)/sum(j1)
                    if (i2.gt.0) aa(irow,k3) = sum(i2)*ovi/sum(j1)
                    go to 54
                    
                    !                 *****  now i1 .ge.ib but j1 < ib
                    
53                  cc(irow) = hl(i1,j1) - ekin(i1,j1)
                    aa(irow,k1) = d1
54                  aa(irow,k2) = ovj
                    go to 55
                    
                    !                 *****  i1 is part of the frozen core
                    
52                  if (j1 .lt. ib) go to 55
                    
                    !                 *****  i1<ib but j1 .ge. ib
                    
                    cc(irow) = hl(j1,i1) - ekin(j1,i1)
                    aa(irow,k1) = sum(i1)/sum(j1)
                    if (i2 .ne. 0) aa(irow,k3) = sum(i2)*ovi/sum(j1)
                    
                    !                 *****  now interchange j1 and j2 and increment the row
                    
55                  jt=j1
                    j1=j2
                    j2=jt
                    ktt=k1
                    k1=k2
                    k2=ktt
                    ktt=k3
                    k3=k4
                    k4=ktt
51                  continue
                    irow = irow + 1
                 enddo
                 
                 !              *****  now interchange i1 and i2 and repeat
                 
                 it = i1
                 i1 = i2
                 i2 = it
                 ktt = k1
                 k1 = k3
                 k3 = ktt
                 ktt = k2
                 k2 = k4
                 k4 = ktt
50               continue
              enddo
              
              !           *****  now solve the system of equations
              
              do k = 1,3
                 
                 !              *****  search for the largest pivot in the k'th column
                 
                 lm = k
                 dm = abs(aa(k,k))
                 kp = k+1
                 do kk = kp,4
                    dd = abs(aa(kk,k))
                    if (dm .ge. dd) go to 61
                    dm = dd
                    lm = kk
61                  continue
                 enddo
                 if (lm .eq. k) go to 65
                 
                 !              *****  interchange the rows
                 
                 do kk = k,5
                    t = aa(k,kk)
                    aa(k,kk) = aa(lm,kk)
                    aa(lm,kk) = t
                 enddo
                 
                 !              *****  eliminate the k'th variable
                 
65               if (aa(k,k) .eq. d0) go to 60
                 do kk = kp,4
                    ratio = aa (kk,k)/aa(k,k)
                    do kkk = kp,5
                       aa(kk,kkk) = aa(kk,kkk) - ratio*aa(k,kkk)
                    enddo
                 enddo
60               continue
              enddo
              
              !           *****  backsubstitute allowing for the possibility that the rank
              !           *****  of the system may only be 2.
              
              if (aa(4,4) .ne. d0) xx(4) = cc(4)/aa(4,4)
              if (aa(3,3) .ne. d0) xx(3) = (cc(3) - aa(3,4)*xx(4))/aa(3,3)
              xx(2) = (cc(2) - aa(2,3)*xx(3) - aa(2,4)*xx(4))/aa(2,2)
              xx(1) = (cc(1) - aa(1,2)*xx(2) - aa(1,3)*xx(3) - aa(1,4)*xx(4))/aa(1,1)
              
              !           *****  compute and print the off-diagonal energy parameters
              
              irow = 1
              do k =1,2
                 if (i1 .eq. 0) go to 72
                 do kk = 1,2
                    e(i1,j1) = xx(irow)
                    e(j1,i1) = sum(i1)*xx(irow)/sum(j1)
                    write(ouc,24) el(i1),el(j1),e(i1,j1),el(j1),el(i1),e(j1,i1)
24                  format(10x,'e(',2a3,') = ',f12.6,4x,'e(',2a3,') = ',f12.6)
                    
                    !                 *****  interchange j1 and j2
                    
                    jt = j1
                    j1 = j2
                    j2 = jt
71                  continue
                    irow = irow + 1
                 enddo
                 
                 !              *****  interchange i1 and i2
                 
72               it = i1
                 i1 = i2
70               i2 = it
              enddo
              
              go to 4
              
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

        !           *****  nnj and ni = 1
        
6       if (j .ge. ib) go to 28
        e(i,j) = hl(i,j) - ekin(i,j)
        go to 22
28      g = elagr(i,j)
        if ( g .ne. d0) go to 27
        if ( .not. ezero ) go to 21
        go to 4
27      g = d2*g/(qi - qj)
        e(i,j) = g*qj
        e(j,i) = g*qi
        go to 22
21      e(i,j) = hl(i,j) - ekin(i,j)
        e(j,i) = hl(j,i) - ekin(j,i)
        e(i,j) = qj*(e(i,j) + e(j,i))/(qi + qj)
        e(j,i) = qi*e(i,j)/qj

22      write(ouc,24) el(i),el(j),e(i,j),el(j),el(i),e(j,i)

        if (irel.ne.0) then
           print *,"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx" 
           e(j,i) = d0
           e(i,j) = d0
        endif
        write(*,24) el(i),el(j),e(i,j),el(j),el(i),e(j,i)

4       continue
     enddo
2    continue
  enddo
  
end subroutine grange
