! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The quasirelativistic potential modifies solutions of the Fock
! *     equations (orbitals and potentials). Its asymptotic behaviour near
! *     the origin is needed to provide correct starting values for the
! *     solutions. But this behaviour is determined by the asymptotic
! *     behaviour of the Coulomb and local exchange potentials (used in
! *     the correction). 

! *     We assume that the asymptotic behaviour is of the form:

! *     V_C -V_{lx} = z_1 r +  z_2 r^2 + z_3 r^3

! *     z_1 parameter is used to modify the starting values of orbitals
! *     (see solve and start). It is also used by quadr when evaluating
! *     the [0..rho] part of the integral.
! *
! *****
subroutine gencoeff(ii)
  use global
  use params
  use relativity
  use wave

  implicit none
  integer :: i,ii,info,lda,lwork,ma,na
  real (PREC) :: at,at1,at2 
!  integer, external :: 
  real (PREC), external :: zvar 

  parameter (lda=3,ma=3,na=3)

  real (PREC), dimension(lda,3) :: a
  real (PREC), dimension(lda,1) :: b
  real (PREC), dimension(10*ma*na) :: work

  do i=1,ma
     a(i,1)=rr(i)
     a(i,2)=rr(i)*r(i)
     a(i,3)=rr(i)*rr(i)
     !        b(i,1)=vxch(i)*r(i)+z
     b(i,1)=vxch(i)*r(i)+zvar(i)
  enddo
  !     LAPACK routines are used to solve the system of linear equations
  lwork=10*ma*na
  call dgels('N',ma,na,ione,a,lda,b,lda,work,lwork,info)
  z1=b(1,1)
  
  if (info.ne.0) then
     write(*,'("Error: DGELS returns with INFO =",i3)') info
     stop 'gencoeff'
  endif
  
  if(idbg(10).ne.0)  then
     write(ouc,*) 'gencoeff: dgels'
     write(ouc,*) 'b(1,1),b(2,1),b(3,1)',b(1,1),b(2,1),b(3,1)
     write(ouc,*) 'checking accuracy of solution: x Ax (Ax-b)/b'
     do i=1,ma
        at=(z1*rr(i)+b(2,1)*rr(i)*r(i)+b(3,1)*rr(i)*rr(i))/(vxch(i)*r(i)+zvar(i))-1.d0
        at1=z1*rr(i)+b(2,1)*rr(i)*r(i)+b(3,1)*rr(i)*rr(i)
        at2=(vxch(i)*r(i)+zvar(i))
        write(ouc,'(2d14.6,3d10.2)') r(i),at1,at,zvar(i)/r(i),z1*r(i)
     enddo
     stop 'gencoeff'
  endif
  
end subroutine gencoeff
