! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The ecoul subroutine calculates Coulomb contribution to total
! *     energy by Simpson's rule
! *     
! *     FIXME d contribution is missing (this contribution is negligible if
! *     small enough values of initial rho are used)
! *
! *****
subroutine ecoul(cenergy)
  use global
  use ode
  use params
  use relativity
  use state
  use wave

  implicit none
  integer :: i,jj,jp,mm
  real (PREC) :: cenergy,d

  cenergy=d0
  do i=1,nwf
     call potl(i)
     
     d=d0
     mm = maxv(i) - 1
     do jj = 2,mm,2
        jp = jj + 1
        d = d + d2*p(i,jj)*p(i,jj)*(yr(jj))/r(jj)*rr(jj) + p(i,jp)*p(i,jp)*(yr(jp))/r(jp)*rr(jp)
        
     enddo
     cenergy=cenergy+qc(i,1)/d2 * d*h1
  enddo
end subroutine ecoul



