! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *	diffs calculates the first (second) derivative of the function
! *	stored in the array vin if io=1 (io=2) and returns the result in
! *	the array v
! *
! *****
subroutine diffs(vin,v,io)
  use global
  use params

  implicit none
  integer :: i,io,j,k,kk,kl,kr
  real (PREC) :: a1,a2,a3,a4,a5,a6,a7,a8,a9,am1,am2,am3,dv1,dv2,dv3,dv4 
  real (PREC), dimension(maxno) ::  vin,v

  if (io.eq.1) then
     kl=4
     kr=no-3
     am3=vin(1)
     am2=vin(2)
     a1 =vin(5)
     a2 =vin(6)
     do i=4,kr
        am1=vin(i-1)
        a3 =vin(i+3)
        v(i)=(a3+45.0_PREC*a1+9.0_PREC*am2-am3-45.0_PREC*am1-9.0_PREC*a2)/60.0_PREC/h
        a1=a2
        a2=a3
        am3=am2
        am2=am1
     enddo
  elseif (io.eq.2) then
     kl=5
     kr=no-4
     a1=vin(1)
     a2=vin(2)
     a3=vin(3)
     a4=vin(4)
     a5=vin(5)
     a6=vin(6)
     a7=vin(7)
     a8=vin(8)
     do i=5,kr
        a9=vin(i+4)
        v(i)=(-9.0_PREC*(a9+a1)+128.0_PREC*(a8+a2)-1008.0_PREC*(a7+a3)+8064.0_PREC*(a6+a4)-14350.0_PREC*a5)/5040.0_PREC/(h*h)
        a1=a2
        a2=a3
        a3=a4
        a4=a5
        a5=a6
        a6=a7
        a7=a8
        a8=a9
     enddo
  endif
  
  !     extrapolate v(i) for i=1,2,...,kl-1

  dv1=v(kl+1)-v(kl)
  dv2=(v(kl+2)+v(kl)-d2*v(kl+1))/d2
  dv3=(v(kl+3)-v(kl)+d3*(v(kl+1)-v(kl+2)))/d6
  dv4=(v(kl+4)+v(kl)+  d6*v(kl+2)-	d4*(v(kl+3)+v(kl+1)))/d2/d12
  kk=kl-1
  do j=1,kk
     k=-kl+j
     v(j)=v(kl)+dble(k)*(dv1+dble(k-1)*(dv2+dble(k-2)*(dv3+dble(k-3)*dv4)))
  enddo
  
  !     extrapolate v(i) for i=kr+1,kr+2,...,no
  
  dv1=v(kr)-v(kr-1)
  dv2=(v(kr)+v(kr-2)-d2*v(kr-1))/d2
  dv3=(v(kr)-v(kr-3)+d3*(v(kr-2)-v(kr-1)))/d6
  dv4=(v(kr)+v(kr-4)-d4*(v(kr-1)+v(kr-3))+d6*v(kr-2))/(d2*d12)
  kk=kr+1
  do j=kk,no
     k=-kk+j+1
     v(j)=v(kr)+dble(k)*(dv1+dble(k+1)*(dv2+dble(k+2)*(dv3+dble(k+3)*dv4)))
  enddo
  
end subroutine diffs
