! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     diag computes and diagonalizes energy matrix
! *
! *****
subroutine diag(etotal,econv1,acfg,cfgtol,nc,last1)
  use global
  use coeffs
  use ode
  use params
  use relativity
  use state
  use wave

  implicit none
  logical*1 :: econv1,last1
  integer :: i,ii,ip,j,jj,jp,k,kmax,li,lij,lj,nc,n1,n2,nfg,nfp,nm,nv
  real (PREC) :: acfg,cfgtol,c,cc,ccc,cont,etl,etotal,etprev,fkij,ratio
!  integer, external :: 
  real (PREC), external :: fk,gk,hl,quadr,rk

  real (PREC), dimension(5) :: gkij
  real (PREC), dimension(40) :: wp
  real (PREC), dimension(40,40) :: w

  !     *****  compute kinetic energy if necessary
  
  if (ib .gt. nwf) go to 51
  
  do i = ib,nwf
     ek(i) = -d5*hl(i,i)
  enddo
  !     *****  set up the energy matrix for different configurations leaving
  !     *****  an nc by nc principal submatrix unchanged

51 continue
  do i = 1,ncfg
     wp(i) = wt(i)
  enddo
  
  do ii = nc,ncfg
     do jj = 1,ii
        et(jj,ii) = d0
        et(ii,jj) = d0
     enddo
  enddo
  
  
  do i = 1,nwf
     if (sum(i) .eq. d0) go to 2
     li = l(i) + 1
     if (li .gt. 5) go to 2
     do j = 1,i
        if (sum(j) .eq. d0) go to 3
        lj = l(j) + 1
        if (lj .gt. 5) go to 3
        lij = abs(li - lj)
        kmax = (li + lj - lij)/2
        if (i .ne. j) fkij = fk(i,j,izero)
        do k = 1,kmax
           gkij(k) = gk(i,j,lij+2*(k-1))
        enddo
        
        do ii = nc,ncfg
           c = qc(i,ii)
           if (i .eq. j) go to 6
           cc = c*qc(j,ii)
           et(ii,ii) = et(ii,ii) + cc*fkij
           do k = 1,kmax
              ccc = cb(li,lj,k)
              et(ii,ii) = et(ii,ii) - cc*ccc*gkij(k)
           enddo
           go to 5
6          cc = d5*c*(c-d1)
           et(ii,ii) = et(ii,ii) + c*ek(i) + cc*gkij(1)
           
           if (li .eq.1) go to 5
           
           do k = 2,kmax
              et(ii,ii) = et(ii,ii) - ca(li-1,k-1)*cc*gkij(k)
           enddo
5          continue
        enddo
3       continue
     enddo
2    continue
  enddo
  
  if (nf .eq. 0) go to 10
  
  !  *****  add contributions from 'fk' integrals
  
  do i = 1,nf
     n1 = nci(i)
     n2 = ncj(i)
     cont = d5*cfg(i)*fk(ifg(i),jfg(i),kfg(i))
     et(n1,n2) = et(n1,n2) + cont
     et(n2,n1) = et(n2,n1) + cont
  enddo
10 if (ng .eq. 0) go to 12
  
  !  *****  add contributions from 'gk' integrals
  
  nfp = nf + 1
  nfg = nf + ng
  do i=nfp,nfg
     n1 = nci(i)
     n2 = ncj(i)
     cont = d5*cfg(i)*gk(ifg(i),jfg(i),kfg(i))
     et(n1,n2) = et(n1,n2) + cont
     et(n2,n1) = et(n2,n1) + cont
  enddo
  
12 if (nr .eq. 0) go to 41
  
  !  *****  add contributions from 'rk' integrals
  
  do i = 1,nr
     n1 = ncri(i)
     n2 = ncrj(i)
     cc = d1
     if (iq(i) .ne. 0) cc = quadr(io(i),jo(i),izero)**iq(i)
     cont = d5*cr(i)*cc*rk(i1r(i),i2r(i),j1r(i),j2r(i),kr(i))
     et(n1,n2) = et(n1,n2) + cont
     et(n2,n1) = et(n2,n1) + cont
  enddo
  
41 if ( nl .eq. 0 ) go to 14
  
  !  *****  add contribution ftom the 'l' integrals

  do i = 1,nl
     n1 = ncli(i)
     n2 = nclj(i)
     cc = d1
     if (lq(i) .ne. 0) cc = quadr(ilo(i),jlo(i),izero)**lq(i)
     cont = d5*cc*cl(i)*hl(ili(i),ilj(i))
     et(n1,n2) = et(n1,n2) + cont
     et(n2,n1) = et(n2,n1) + cont
  enddo
  
14 if (ncfg .eq. 1) go to 37
  if (id .gt. 0) go to 38

  !  *****  compute eigenvalue and eigenvector by the method of
  !  *****  sec. 6-8.2  this method may cause difficulties when near
  !  *****  degeneracy effects are present since it may converge to
  !  *****  the wrong eigenvalue.  the code up to, but not including
  !  *****  statement number 31, may be replaced by a call to a more
  !  *****  refined library subroutine.
  etprev = d0
  
  do 30 ii = 1,5
     etl = d0
     
     !  *****  determine estimates of the eigenvalue
     
     do i=1,ncfg
        cont = d0
        do j = 1,ncfg
           cont = cont + wt(j)*et(i,j)
        enddo
        etl = etl + wt(i)*cont
     enddo
     
     !  *****  solve system of equations for eigenvector

     do i=1,ncfg
        do j=1,ncfg
           w(i,j) = et(i,j)
           w(i,i) = w(i,i) - etl
        enddo
     enddo
     wt(1) = d1
     if (ncfg .ne.2) go to 54
     wt(2) = -w(2,1)/w(2,2)
     go to 20
     
54   nm = ncfg - 1
     do i=2,nm
        ip = i + 1
        do j=ip,ncfg
           ratio = w(j,i)/w(i,i)
           do k=1,ncfg
              w(j,k) = w(j,k) - ratio*w(i,k)
           enddo
        enddo
     enddo
     wt(ncfg) = -w(ncfg,1)/w(ncfg,ncfg)
     
     do i=2,nm
        j = ncfg - i + 1
        jp = j + 1
        wt(j) = -w(j,1)
        do k = jp,ncfg
           wt(j) = wt(j) - w(j,k)*wt(k)
        enddo
        wt(j) = wt(j)/w(j,j)
     enddo
     
20   do i = 2,ncfg
        wt(1) = wt(1) + wt(i)**2
     enddo
     
     wt(1) = d1/sqrt(wt(1))
     do i = 2,ncfg
        wt(i) = wt(i)*wt(1)
     enddo
     
     !  *****  iterate, if necessary, otherwise output results
     
     if (abs((etprev-etl)/etl) .lt. 1.d-5) go to 31
30   etprev = etl
     write(ouc,40)
40   format(///10x,47hmatrix diagonalization procedure not converging )
     deltae = d0
     go to 33
31   deltae = etl - etotal
33   etotal = etl
     write(ouc,32) etotal
32   format(//10x,15htotal energy = ,d22.14// )
39   write(ouc,34)
34   format(/15x,6hweight,13x,13henergy matrix )
     cc = d0
     do i = 1,ncfg
        wt(i) = wt(i) + acfg*(wp(i) - wt(i))
        cc = cc + wt(i)**2
     enddo
     cc = d1/sqrt(cc)
     do i = 1,ncfg
        wt(i) = wt(i)*cc
     enddo
     ii = nc
     if (last) ii = 1
     do i = ii,ncfg
        write(ouc,36) i,wt(i),(et(i,j),j=1,i)
     enddo
36   format(i10,f12.8,2x,7f15.7/(24x,7f15.7))
     
70   if (.not. last .or. ouc .eq. 0 ) go to 49
     
     !  *****  punch configurations and weights on unit ouc
     
     write(ouc,46) atom,term,etotal
46   format(3x,2a6,d22.14)
     do j = 1,ncfg
        write(ouc,48) config(1,j),config(2,j),config(3,j),wt(j)
     enddo
48   format(3a8,f10.7)
     
     if ( ouh .eq.0 ) go to 49
     do i = 1,ncfg
        write(ouh,61) (et(i,j),j=1,i)
     enddo
61   format(5f14.7)
     
49   econv = .false.
     if (abs(deltae/etotal) .le. cfgtol) econv = .true.
     return
     
37   etotal = et(1,1)
     if (iuf == 0) deltae = d0
     write(ouc,32) etotal
     go to 70
38   deltae = d0
     etotal = et(1,1)
     go to 39
  
end subroutine diag

