! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *	The dataxpot subroutine reads xpot data card to determine a type
! *	of the local exchange potential to be used in a
! *	quasirelativistic correction (LDA or CG)
! *
! *****
subroutine dataxpot()
  use global
  use card
  use params
  use relativity
  use wave

  implicit none

  character*8 :: clabel, atmp

  call inStr(atmp)
  if     (atmp.eq.'lda') then
     ixpot=1
  elseif (atmp.eq.'cowan1') then
     ixpot=2
  elseif (atmp.eq.'cowan2') then
     ixpot=3
  else
     write(ouc,'("Error: unknown local exchange potential")')
     stop
  endif

end subroutine dataxpot
