! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *	The dataqrpot subroutine reads qpot data card
! *
! *****
subroutine dataqrpot()   
  use global
  use card
  use params
  use relativity
  use wave

  implicit none
  integer :: i,itmp
  real (PREC) :: fsc

  do i=1,nwf
     qm2(i)=0.0_PREC
     qm1(i)=0.0_PREC
     q0 (i)=0.0_PREC
  enddo
  
  !     presence of qrpot label switches on relativistic mode
  !     see setparams for default values of reldamp and reldampsf
  
  irel=1
  !     cveldamp - velocity of light times reldamp
  cveldamp=reldamp*cvel
  
  fsc=d1/cveldamp
  fsc2=fsc*fsc
  
!  iqpot=2
  istate=0
  
  call inInt(itmp)
  if (itmp.ne.inIntExit) then 
     iqpot=itmp
     if (iqpot.eq.0) then
        irel=0
        return
     endif
     call inInt(itmp)
     if (itmp.ne.inIntExit) then 
        istate=itmp
     endif
  endif
  
  call relmesg
  
end subroutine dataqrpot
