! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     This routine reads 'electron' cards
! *
! *****
subroutine datael
  use global
  use card
  use input
  use params
  use relativity
  use state
  use wave

  implicit none
  integer :: i,ifull,itmp,j
  real (PREC) :: ss,tmp1

! FIXME
  character*3 :: bl
  character*4 :: el1,el2
  character*8 :: ellab

  ss=d0
  do i = 1,nwf
     call inCard
     call inStr(ellab)
     el(i)=ellab
     call checklabel(i,ellab)
     call inInt(itmp)
     if (itmp.ne.inIntExit) then
        qc(i,1)=itmp
        if (ncfg.gt.1) then
           do j=2,ncfg
              call inInt(itmp)
              qc(i,j)=itmp
           enddo
        endif
        
        !            call checklabel(i,ellab)
        call inInt(itmp)
        if (itmp.ne.inIntExit) then
           n(i)=itmp
           call inInt(itmp)
           l(i)=itmp
           call inFloat(tmp1)
           s(i)=tmp1
           call inInt(itmp)
           meth(i)=itmp
           call inFloat(tmp1)
           acc(i)=tmp1
           call inInt(itmp)
           ind(i)=itmp
           if (iuf.ne.0) ind(i)=-1
        else

           ifull=2*(2*l(i)+1)
           s(i)=ss+dble(ifull)/d2
           !              be carefull in case excited orbitals are present 
           if (s(i).ge.z) then
              if (i.gt.1) then
                 s(i)=s(i-1)
              else
                 s(i)=z-dble(ifull)/d2
              endif
           endif
           ss=ss+ifull
           meth(i)=0
           acc(i)=0
           if (iuf.ne.0) then
              ind(i)=-1
           else
              ind(i)= 0
           endif
        endif
     else
        call checklabel(i,ellab)
        ifull=2*(2*l(i)+1)
        s(i)=ss+ifull/2
        ss=ss+ifull
        meth(i)=0
        acc(i)=0
        if (iuf.ne.0) then
           ind(i)=-1
        else
           ind(i)= 0
        endif
     endif
     
     ! FIXME
     !        for H 1s(1) (Z=1) s(i) is automaticaly set to the (incorrect)
     !        value of 1 (=ifull/2). 
     
     if ( abs(s(i)-z).lt.0.0010_PREC ) then
        s(i)=d0
     endif

     write (ouc,8) i,el(i),n(i),l(i),s(i),meth(i),acc(i),ind(i),(qc(i,j),j=1,ncfg)
8    format(6x,i4,2x,a3,2i3,f7.1,i4,f6.1,i4,1x,20f4.0/43x,20f4.0)
     
     sum(i) = d0
     do j = 1,ncfg
        if (qc(i,j) .gt. d0 ) sum(i)=sum(i) + qc(i,j)*wt(j)**2
        if ( qc(i,j) .lt. d0 ) qc(i,j) = 1.e-15_PREC
     enddo
     
     !  *****  initialize arrays, if necessary
     
     if (ind(i) .eq. 1) go to 9
     e(i,i) = d0
     ek(i) = d0
     az(i) = d0
     rscan(i) = .true.
9    continue
  enddo

end subroutine datael
