! *****
! *****	Copyright (C) 1978 Charlotte Froese Fisher                                   
! ***** 	Copyright (C) 2012 Jacek Kobus                                               
! *****
! *
! *     The data routine reads 'atom', 'electron' and 'integrals' inputa
! *     data cards
! *
! *****
subroutine data(new)
  use global
  use card
  use params
  use relativity
  use state
  use wave

  implicit none
  integer :: i,i1,i2,ii,itmp,j1,j2,jj,new,nfg
  integer :: ioshell,noshell
  integer, dimension(2) :: oshell
  integer, dimension(3) :: denomin,nomin
  real (PREC) :: ftmp,qcc,qcoshell,rhomax,w
  integer, external :: findOShell

  character*1 :: fint,gint,cfgl24
  character*4 :: bl,el1,el2
  character*8 :: clabel,cfgl8a,cfgl8b,cfgl8c
  character*80 :: intcard 

  data bl/'    '/
  data fint/'F'/,gint/'G'/

  !     ncfg - number of configurations is set to 1
  ncfg=1
  new=0
  
  nf=0
  ng=0
  nr=0
  nl=0

  !     *****  read 'atom' card
  call inStr(atom)
  call inStr(term)
  call inFloat(z)
  call inInt(nwf)

  !     calculate rmax
  rhomax=rho+(no-1)*h
  rmax=exp(rhomax)/z
  
  !     by default all orbitals are being relaxed
  nit=nwf
  
  call inInt(itmp)
  if (itmp.ne.inIntExit) then 
     nit=itmp
     call inInt(itmp)
     if (itmp.ne.inIntExit) then 
        ncfg=itmp
        call inInt(itmp)
        if (itmp.ne.inIntExit) then 
           nf=itmp
           call inInt(itmp)
           if (itmp.ne.inIntExit) then 
              ng=itmp
              call inInt(itmp)
              if (itmp.ne.inIntExit) then 
                 nr=itmp
                 call inInt(itmp)
                 if (itmp.ne.inIntExit) then 
                    nl=itmp
                 endif
              endif
           endif
        endif
     endif
  endif
  
1 format(2a6,f6.0,i6,7i3,2l3,i3)
  ib = nwf - nit + 1
  nd = no - 2

  write (ouc,2) atom,term,z
2 format(/9x,33hHartree-Fock wave functions for  ,2a6,4h Z = ,f5.1//20x,13hconfiguration,24x,6hweight/)

  !      omit = .not. omit
  if (ncfg.eq.1) then
     w = d0
     do i = 1,ncfg
        config(1,i)=''
        config(2,i)=''
        config(3,i)=''
        wt(i) = d1
        w = w + wt(i)**2
     enddo
  else
     
     write(ouc,100)
100  format('Warning!',/,'Multiconfiguration calculations are not supported by the present version of the program.' &
          /,'Modify subroutine data.f to proceed.')
     !         stop 'data'
     
     w = d0
     do i = 1,ncfg
        !            read (iuc,*) config(1,i),config(2,i),config(3,i),wtt,lwt
        call inCard
        call inStr(clabel)
        config(1,i)=clabel
        config(2,i)=''
        config(3,i)=''
        call inFloat(ftmp)
        if (ftmp.ne.d0) then
           wt(i)=ftmp
        else
           wt(i)=one
        endif
        w = w + wt(i)**2
     enddo
  endif
  
  !     normalize configuration weights
  w = sqrt(w)
  do i = 1,ncfg
     wt(i) = wt(i)/w
     write (ouc,5) i, config(1,i), config(2,i), config(3,i),wt(i)
  enddo
5 format(14x,i2,6x,3a8,f19.8)
  
  write(ouc,6) (i,i=1,ncfg)
6 format(/9x,10hinput data/9x,10h----- ----//13x,14hwave function,, &
       11 h  procedure,2x,41hnumber of electrons in each configuration/ &
       17 x,26hn  l  sigma meth  acc  ind,20i4/40x,20i4)
  
  write(ouc,*)
  
  !     *****  read 'electron' card
  call datael
  
  write(ouc,66)
66 format(/)
  
  write (ouc,10)
10 format(/9x,9henergy = ,9x,12he(average) + /)
  
  !     *****  read 'fk' and 'gk' cards
  
  nfg = nf + ng
  if (nfg .eq. 0) go to 13
  do i = 1,nfg
     read (iud,*) cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
11   format(g12.8,a1,i1,1x,2i2,1x,2i2)
     
     !         if ( oud .eq. 0 ) go to 20
     i1 = ifg(i)
     i2 = jfg(i)
     write (ouc,12) cfg(i),nci(i),ncj(i),fint,kfg(i),el(i1),el(i2)
12   format(26x,f14.8,3h*c(,i2,4h)*c(,i2,2h),,a1,i1,1 h(,a3,1h,,a3,1h))
20   continue
  enddo
  
13 if (nr .eq. 0) go to 17
  
  !     *****  read 'rk' cards and set rscan(i)=.false. if wavefunction  i
  !     *****  is present in the rk integral
  
  do i=1,nr
     read (iud,*) cr(i),kr(i),i1r(i),i2r(i),ncri(i),j1r(i),j2r(i),ncrj(i),io(i),jo(i),iq(i)
15   format(g12.8,1x,i1,1x,3i2,1x,3i2,2x,i2,1x,i2,1x,i2)
     i1 = i1r(i)
     i2 = i2r(i)
     j1 = j1r(i)
     j2 = j2r(i)
     if (iq(i) .eq. 0) go to 30
     ii = io(i)
     jj = jo(i)
     rscan(ii) = .false.
     rscan(jj) = .false.
30   continue
     
     write (ouc,16) cr(i),ncri(i),ncrj(i),kr(i),el(i1),el(i2),el(j1),el(j2),bl,bl,iq(i)
16   format(26x,f14.8,3h*c(,i2,4h)*c(,i2,3h) R,i1,1 h(,2a3,1h,,2a3,2h)<,a3,1h|,a3,1h>,i2)
     if ( abs(cr(i)) .lt. 1.d-20 ) go to 14
23   rscan(i1) = .false.
     rscan(i2) = .false.
     rscan(j1) = .false.
     rscan(j2) = .false.
14   continue
  enddo
  
17 if (nl .eq. 0) go to 31
  
  !  *****  read 'l' cards
  
  do i = 1,nl
     read (iud,*) cl(i),ili(i),ncli(i),ilj(i),nclj(i),ilo(i),jlo(i),lq(i)
33   format(f12.8,2x,2i2,1x,2i2,2x,i2,1x,i2,1x,i2)
     i1 = ili(i)
     j1 = ilj(i)
     if (lq(i) .eq. 0) go to 34
     i2 = ilo(i)
     j2 = jlo(i)
     el1 = el(i2)
     el2 = el(j2)
     rscan(i2) = .false.
     rscan(j2) = .false.
     
     write (ouc,35) cl(i),ncli(i),nclj(i),el(i1),el(j1),el1,el2,lq(i)
     go to 24
     
34   continue
     
     write (ouc,35) cl(i),ncli(i),nclj(i),el(i1),el(j1),bl,bl,lq(i)
35   format(26x,f14.8,3h*c(,i2,4h)*c(,i2,4h) l(,a3,1h,,a3,2h)<,a3,1h|,a3,1h>,i2)
     
24   rscan(i1) = .false.
     rscan(j2) = .false.
32   continue
  enddo
  
31 continue


  ! If term != av|AV and is equal to 3P, 2D, etc and nr+ng==0 then the deviation from the
  ! average energy is taken into account automatically 

  if ( term /='av' .and. term /='AV' .and. nr+ng==0 ) then
     ! find open shells
     ioshell=0
     noshell=0
     do i=nwf,1,-1
        qcc=findOShell(i)
        if (qcc /= 0 ) then
           noshell=noshell+1
           ioshell=i
           oshell(noshell)=i
        endif
     enddo
     if (noshell > 2 ) then
        write(ouc,"( 'data: Energy deviations are not available for more than two open shells ...')") 
     endif


     if (ncfg > 1 ) then
        write(ouc,"( 'data: Energy deviations are not available for more than one configuration ...')") 
     endif

     ! p-shell
     
     select case (noshell) 
     case (0) 
        return
        
     case (1)
        qcoshell=qc(oshell(1),1)
        if ( l(oshell(1)) == 1 ) then
           ! p^2 or p^4  3P F^2(p,p)=-3/25
           if ( qcoshell == 2 .or. qcoshell == 4) then
              nfg=1
              i=1
              kfg(i)=2
              if ( term == '3P' .or. term == '3p' ) then
                 nomin(i)=-3
                 denomin(i)=25
              elseif ( term == '1D' .or. term == '1d' ) then
                 nomin(i)=3
                 denomin(i)=25
              elseif ( term == '1S' .or. term == '1s' ) then
                 nomin(i)=12
                 denomin(i)=25
              else
                 goto 500
              endif
              
              write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,2,ioshell,1,ioshell,1
              read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
           endif
           
           ! p^3 or p^4 F^2(p,p)=-3/25
           if ( qcoshell == 3 ) then
              nfg=1
              i=1
              kfg(i)=2
              if ( term == '4S' .or. term == '4s' ) then
                 nomin(i)=-9
                 denomin(i)=25
              elseif ( term == '2D' .or. term == '2d' ) then
                 nomin(i)=0
                 denomin(i)=25
              elseif ( term == '2P' .or. term == '2p' ) then
                 nomin(i)=6
                 denomin(i)=25
              else
                 goto 500
              endif
              
              write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,2,ioshell,1,ioshell,1
              read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
           endif
        endif
        
        ! d shell
        if ( l(ioshell) == 2 ) then
           ! d^2 or d^8  
           if ( qcoshell == 2 .or. qcoshell == 8) then
              nfg=2
              
              if ( term == '3F' .or. term == '3f' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-58
                 denomin(i)=441
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=5
                 denomin(i)=441
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
           
           ! d^3 or d^7 
           if ( qcoshell == 3 .or. qcoshell == 7 ) then
              nfg=2
              if ( term == '4F' .or. term == '4f' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-93
                 denomin(i)=441
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=-30
                 denomin(i)=441
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
           
           
           ! d^4 or d^6 
           if ( qcoshell == 4 .or. qcoshell == 6 ) then
              nfg=2
              if ( term == '5D' .or. term == '5d' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-105
                 denomin(i)=441
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=-105
                 denomin(i)=441
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
           
           ! d^5 
           if ( qcoshell == 5) then
              nfg=2
              if ( term == '6S' .or. term == '6s' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-175
                 denomin(i)=441
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=-175
                 denomin(i)=441
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
        endif
        
        ! f shell
        if ( l(ioshell) == 3 ) then
           ! f^2 or f^12  
           if ( qcoshell == 2 .or. qcoshell == 12) then
              nfg=3
              
              if ( term == '3H' .or. term == '3h' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-53
                 denomin(i)=585
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=-155
                 denomin(i)=4719
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=3
                 kfg(i)=6
                 nomin(i)=2975
                 denomin(i)=184041
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
              else
                 goto 500
              endif
           endif
           
           ! f^3 or f^11  
           if ( qcoshell == 3 .or. qcoshell == 11) then
              nfg=3
              
              if ( term == '4I' .or. term == '4i' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-133
                 denomin(i)=585
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=-413
                 denomin(i)=4719
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=3
                 kfg(i)=6
                 nomin(i)=4375
                 denomin(i)=184041
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
           
              
           ! f^4 or f^10  
           if ( qcoshell == 4 .or. qcoshell == 10) then
              nfg=3
              
              if ( term == '5I' .or. term == '5i' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-35
                 denomin(i)=117
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=-644
                 denomin(i)=4719
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=3
                 kfg(i)=6
                 nomin(i)=-7175
                 denomin(i)=184041
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
           
           
           ! f^5 or f^9  
           if ( qcoshell == 5 .or. qcoshell == 9) then
              nfg=3
              
              if ( term == '6H' .or. term == '6h' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-179
                 denomin(i)=585
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=-848
                 denomin(i)=4719
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=3
                 kfg(i)=6
                 nomin(i)=-31675
                 denomin(i)=184041
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
           
           
           ! f^6 or f^8  
           if ( qcoshell == 6 .or. qcoshell == 8) then
              nfg=3
              if ( term == '7F' .or. term == '7f' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-14
                 denomin(i)=39
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=-35
                 denomin(i)=143
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=3
                 kfg(i)=6
                 nomin(i)=-1750
                 denomin(i)=5577
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
           
           
           ! f^7
           if ( qcoshell == 7 ) then
              nfg=3
              if ( term == '8S' .or. term == '8s' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-98
                 denomin(i)=195
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=2
                 kfg(i)=4
                 nomin(i)=-49
                 denomin(i)=143
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 i=3
                 kfg(i)=6
                 nomin(i)=-2450
                 denomin(i)=5577
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
        endif
     
     case (2)

        ! if ( l(oshell(1)) == 0 .and. l(oshell(2)) == 0 ) then
        !    ! l^n(LS')sLS 
        !    if ( qc(oshell(1),1) == d1 .or. qc(oshell(2),1) == d1 ) then
        !       nfg=1
        !       i=1
        !       kfg(i)=2
        !       nomin(i)=1
        !       denomin(i)=25
        !       write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
        !       read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
        !    endif
        ! endif

           
        if ( l(oshell(1)) == 1 .and. l(oshell(2)) == 1 ) then
           ! pp'
           if ( qc(oshell(1),1) == d1 .and. qc(oshell(2),1) == d1 ) then
              nfg=3
              if ( term == '3D' .or. term == '3d' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=1
                 denomin(i)=25
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=2
                 kfg(i)=0
                 nomin(i)=-5
                 denomin(i)=6
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=3
                 kfg(i)=2
                 nomin(i)=2
                 denomin(i)=75
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)

              elseif ( term == '1D' .or. term == '1d' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=1
                 denomin(i)=25
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=2
                 kfg(i)=0
                 nomin(i)=7
                 denomin(i)=6
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=3
                 kfg(i)=2
                 nomin(i)=8
                 denomin(i)=75
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              elseif ( term == '3P' .or. term == '3p' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=-1
                 denomin(i)=5
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=2
                 kfg(i)=0
                 nomin(i)=7
                 denomin(i)=6
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=3
                 kfg(i)=2
                 nomin(i)=-2
                 denomin(i)=15
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)

              elseif ( term == '3S' .or. term == '3s' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=2
                 denomin(i)=5
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=2
                 kfg(i)=0
                 nomin(i)=-5
                 denomin(i)=6
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=3
                 kfg(i)=2
                 nomin(i)=-1
                 denomin(i)=3
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)

              elseif ( term == '1S' .or. term == '1s' ) then
                 i=1
                 kfg(i)=2
                 nomin(i)=2
                 denomin(i)=5
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),fint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),fint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=2
                 kfg(i)=0
                 nomin(i)=7
                 denomin(i)=6
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
                 
                 i=3
                 kfg(i)=2
                 nomin(i)=7
                 denomin(i)=15
                 write(intcard,'(d24.16,2x,a2,2x,5i5)') dble(nomin(i))/dble(denomin(i)),gint,kfg(i),ioshell,1,ioshell,1
                 read (intcard,'(d24.16,2x,a2,2x,5i5)') cfg(i),gint,kfg(i),ifg(i),nci(i),jfg(i),ncj(i)
              else
                 goto 500
              endif
           endif
        end if
     end select
     
  end if


  do i = 1,nfg
     i1 = ifg(i)
     i2 = jfg(i)
     write (ouc,120) nomin(i),denomin(i),nci(i),ncj(i),fint,kfg(i),el(i1),el(i2)
  enddo

120 format(26x,i6,'/',i6,2x,3h*c(,i2,4h)*c(,i2,2h),,a1,i1,1 h(,a3,1h,,a3,1h))           

  return

500 continue
  write(ouc,'(3x,"Warning! Unknown term specification: ",a4,"; no energy deviation term added.")') term
!  stop 'data'
  return

  ! FIXME
  !      write(ouc,25) nf, ng, nr, nl
  !25    format(19x,i3,17h fk integral(s) +/19x,i3,17h gk integral(s) +/
  !     1	     19x,i3,17h rk integral(s) +/19x,i3,15h  l integral(s) )
end subroutine data


function findOShell(i)
  use global
  use params
  use state
  use wave

  implicit none 
  integer :: i,j,findOShell
  integer, dimension(0:4) :: maxoccup
  data maxoccup /2,6,10,14,18/

  do j=1,ncfg
     if ( qc(i,j) < maxoccup(l(i)) ) then
        findOShell=qc(i,j)
        return
   endif
  enddo
  findOShell=0

end function findOShell







