*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The zk subroutine computes a function yk which is the
*     z' = p(i)*p(j) - k*z/r
*
*****
      subroutine zk(i,j,k)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'

      den=dlr(i)+dlr(j)+d3+k
      fact=(zrl(i)/(dlr(i)+d1)+zrl(j)/(dlr(j)+d1))/(den+d1)
      a = eh**k
      a2 = a*a
      h90 = h/90.d0
      a3 = a2*a*h90
      ai = h90/a
      an = 114.d0*a*h90
      a34 = 34.d0*h90
      f1 = rr(1)*p(i,1)*p(j,1)
      f2 = rr(2)*p(i,2)*p(j,2)
      f3 = rr(3)*p(i,3)*p(j,3)
      f4 = rr(4)*p(i,4)*p(j,4)
      yk(1)=f1*(d1+fact*r(1))/den
      yk(2)=f1*(d1+fact*r(2))/den
      yk(3) = yk(1)*a2 + h3*(f3 + d4*a*f2 + a2*f1)

      do m = 5,no
         f5 = rr(m)*p(i,m)*p(j,m)
         yk(m-1) = yk(m-3)*a2 +	( an*f3 + a34*(f4+a2*f2)-f5*ai-f1*a3)
         f1 = f2
         f2 = f3
         f3 = f4
         f4 = f5
      enddo
      yk(no) = a*yk(no-1)

      if (abs(i-j)  +	abs(k) .ne. 0) go to 2

c     *****  for y0(i,i) set the limit to 1 and remove oscillations
c     *****  introduced by the use of simpson's rule

      m2 = (no/2)*2 - 1
      m1 = m2 - 1
      c1 = d1 - yk(m1)
      c2 = d1 - yk(m2)
      do m = 1,m1,2
         yk(m) = yk(m) + c1
         yk(m+1) = yk(m+1) + c2
      enddo
      yk(no) = d1
      yk(no-1) = d1

2     return
      end
