*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The zgauss function returns the value of V(r(i))*r(i) where V is
*     the nuclear potential for the Gaussian charge distribution model
*
*****
      real*8 function zgauss(i)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

c     Evaluate the nuclear potential for Gaussian models.  

      include 'common.inc'
      include 'common-param.inc'

      fmtoau=1.0d-13/ainfcm

c     set atomic weight 

      izz1=nint(z)
      atw=atweight(izz1)
      at3=atw**(one/three)
      rrmsfm = 0.836d0*at3+0.570d0

c     change units from fm into bohr
  
      rrms = rrmsfm*fmtoau

c     exponent of the Gaussian distribution $\rho_0 exp(-\eta r^2)$
c     rrms=(3/(2\eta)^{1/2)
  
      eta1=3.d0/(2.d0*rrms*rrms)

c     making use of F77 intrinsic function 
c     erf(x)=2/(Pi)^(1/2)*int_)^x exp(-t^2)dt
c     if available

      zgauss=z*erf(sqrt(eta1)*r(i))

      return
      end

