*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The ykdft subroutine fills for orbital i the vxch array with
*     (-z+yk)/r+vdft values at grid points
*
*****
      subroutine ykdft(i)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-state.inc'

      call potl(i)


      if (qc(i,1).eq.d1) then
         do k=1,no
            vxch(k)=(-zvar(k)+yr(k))/r(k)
         enddo
      else

c        FIXME yr does not include contributions that are canceled out by
c        exchange terms (if it does total energy gets worse)

         if     (ixpot.eq.1) then
            call potllda(i)

         elseif (ixpot.eq.2) then
            call potlcg1(i)

         elseif (ixpot.eq.3) then
            call potlcg2(i)
         endif

         do k=1,no
            vxch(k)=(-zvar(k)+yr(k))/r(k) + vdft(k)
         enddo
      endif

      return
      end


