*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The wavefn subroutine determins the initial estimates of the wave
*     functions.
*
*****
      subroutine wavefn
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-coeff.inc'
      include 'common-input.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      character*4 elt
      character*8 title(3,3)
      data title/' scaled ','        ','        ',' screene',     
     & 'd hydrog','enic    ',' unchang','ed      ','        '/

c     *****  generate arrays for r,r*r and sqrt(r) with a constant mesh
c     *****  size in the log(z*r) variable

      do i=1,no
         r(i)= exp(rho)/z
         rr(i) = r(i)*r(i)
         r2(i) = sqrt(r(i))
         rho = rho + h
      enddo
      rho = rho - no*h

c     *****  set paramters for electrons and initialize functions

      do i = 1,nwf
         maxv(i) = no
         pn = hnorm(n(i),l(i),z-s(i))
         ii=ind(i)+3
         go to (7,7,8,9),ii

c        *****  read data cards for electron i if ind=-1 on 'electron' card

 7       continue
         read(iuf,10) atm(i),trm(i),elt,m,zz(i),e(i,i),ek(i),az(i),
     &        zrl(i),dlr(i)
         read(iuf,11) (p(i,j),j=1,no)
         read(iuf,10) atm(i),trm(i),elt,m,zz(i),e(i,i),ek(i),az(i),
     &        zrl(i),dlr(i)
         read(iuf,11) (y(i,j),j=1,no)

 10      format(6x,a6,6x,a6,9x,a3,i6,f6.0,/5(4x,d22.15))
 11      format(4d22.15)

c        if ind(i)=-2 reverse the sign of e(i,i) to indicate that
c        this parameter should not be calculated in the first 
c        iteration by solve routine
c
         if(ind(i).eq.-2) e(i,i)=-e(i,i)
	
c        *****  scale results if cards are for an atom with a different z
         
         if (z .eq. zz(i)) go to 20
         zz2 = z/zz(i)
         do j=1,m
            p(i,j)= p(i,j)*zz2
         enddo
 20      if (m .eq. no) go to 4
         maxv(i) = m

c        *****  set remaining values in the range = 0

         m = m +1
         do j=m,no
            p(i,j) = d0
         enddo
         if(ii.eq.1) go to 5
         go to 4

c        ***** determine estimates of the wave functions by the screened
c        ***** hydrogenic approximation

 8       continue
         do j=1,no
            p(i,j) = pn*hwf(n(i),l(i),z-s(i),r(j))/r2(j)
         enddo 

c        *****  if az(i) was not specified on input data, compute

 24      az(i) = pn*(d2*(z - d5*s(i))/n(i))**(l(i) + 1)

c        *****  orthogonalize to inner functions

         
 4       continue

c        do not orthogonalize orbitals when retrieving them from disk

         if (ind(i).ne.-1) then
            if (i .eq. 1 .or. i .lt. ib) go to 5
            im = i - 1
            do ii =1,im
               if (l(i) .ne. l(ii) .or. n(i) .eq. n(ii) ) go to 6
               if (.not.ortho.and.abs(a(i,ii,1)).lt.1.d-20) go to 6
               pn = quadr(i,ii,izero)
               pnn = sqrt(d1 - pn*pn)
               if (p(i,1) - pn*p(ii,1) .lt. d0) pnn = -pnn
               do j = 1,no
                  p(i,j) =(p(i,j) - pn*p(ii,j))/pnn
               enddo
               if (irel.eq.0) then
                  ek(i) = -d5*hl(i,i)
               else
                  irel=0
                  ek(i) = -d5*hl(i,i)
                  irel=1
               endif

 6             continue
            enddo
         endif
 5       continue
c        *****  compute y0(i,i) and store
C$$$         call ykf(i,i,0)
C$$$         do j= 1,no
C$$$            y(i,j) = yk(j)
C$$$         enddo
 9       continue
      enddo

      write(ouc,14)
14    format(/ 9x,18hinitial estimates  /9x,2hnl,
     1     5     x,5hsigma,6x,5he(nl),4x,6hek(nl),4x,
     1     6haz(nl),5x,9hfunctions/)

c     *****  compute one-electron energy parameters if they were not
c     *****  specified on input.

c FIXME
      if (irel.eq.0) then
         do i = 1,nwf
            if ( ek(i) .eq. 0) ek(i) = -d5*hl(i,i)
 22         k = ind(i) + 2
            if(ind(i).eq.-2) k=1
 17         write(ouc,19) el(i),s(i),e(i,i),ek(i),az(i),
     &           (title(j,k),j=1,3)
 19         format(9x,a3,f9.2,f11.3,f10.3,f10.3,a12,2a8)
         enddo
      else
         irel=0
         do i = 1,nwf
c            if ( ek(i) .eq. 0) ek(i) = -d5*hl(i,i)
            k = ind(i) + 2
            if(ind(i).eq.-2) k=1
            write(ouc,19) el(i),s(i),e(i,i),ek(i),az(i),
     &           (title(j,k),j=1,3)
         enddo
         irel=1
      endif

      return
      end
