*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The summary subroutine evaluates and prints the total energy and
*     its contributions and also various one-electron integrals
*
*****
      subroutine summry(ett)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      character*1 d,f,g
      character*4 bl4
      include 'common.inc'
      include 'common-coeff.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-state.inc'
      include 'common-wave.inc'

      dimension r3(20),ss(3),out(5),iw(5),cv(3,4,3),cn(3,4,4)

      data cv/-1.0d0,-.6d0,0.d0,-.6d0,-.2d0,-.1714285714285714d0,.2d0,
     1 2*-.08571428571428571d0,.2571428571428571d0,.08571428571428571d0,
     2 -.028571428571428571d0,2*0.d0,-.4285714285714286d0,0.d0,
     3 -.3428571428571428d0,-.2380952380952380d0,-.5142857142857143d0,
     4 -.2857142857142857d0,-.08571428571428571d0,-.4761904761904762d0,
     5 -.0571428571428571d0,-.0649350649350649d0,8*0.d0,
     6 -.1948051948051948d0,0.d0,-.2597402597402597d0,
     7 -.1748251748251748d0/
      data cn/ 2.d0,1.8d0,0.d0,-1.d0,.8d0,.85714285714285714d0,.8d0,
     1-.6d0,.5142857142857143d0,1.285714285714286d0,.5142857142857143d0,
     2-.4285714285714286d0,-1.d0,-1.2d0,1.714285714285714d0,0.d0,
     3-.1428571428571428d0,-.04761904761904762d0,-1.6857142857142857d0,
     4 .1714285714285714d0,-.2571428571428571d0,-2.476190476190476d0,
     5-.7142857142857142d0,-.1428571428571428d0,2*0.d0,
     6-1.285714285714286d0,0.d0,-.3428571428571428d0,
     7-.4761904761904762d0,.5142857142857143d0,0.d0,
     8 .03376623376623377d0,.9523809523809524d0,
     8 -.3688311688311688d0,-.0649350649350649d0,8*0.d0,
     9 -.1948051948051948d0,0.d0,.2597402597402597d0,0.d0/
      data d/' '/,f/'f'/,g/'g'/,bl4/'    '/

      write (ouc,9) atom,term
 9    format(/// 24x,5hAtom ,a6,3x,5hTerm ,a6//40x,13hmean value of,1x,
     1     22hone electron integrals /2x,2hnl,10x,7h  E(nl),
     2     7x,8h  Az(nl),5x,5hsigma,4x,6h1/r**3,7x,3h1/r,9x,1hr,
     3     8x,4hr**2,7x,5hI(nl),8x,2hKe)

      en = d0

c     *****  compute and print one-electron parametters

c FIXME set lbmax somewhere
      lbmax=0
      if(ouf.eq.0) go to 432
      if(indmc.eq.2) go to 209

      nwf11=nwf
      if(indmc.eq.1) nwf11=ntrgst

 201  format(33h Coulomb potential for electron  ,a3)
 202  format(4d20.13)

 204  format('integrals')   
 205  format('integral',i2)
      
 209  continue
 432  continue

      enpot=d0
      do i = 1,nwf
         r1  = quadr(i,i,-ione)
         rm  = quadr(i,i,ione)
         rmm = quadr(i,i,itwo)

         eii=e(i,i)/2.d0
         r4=quadr(i,i,ifour)

         enpot=enpot+sum(i)*z*r1
         ekinp = ek(i) + z*r1
         en = en+ sum(i)*ekinp
         rh = 3*n(i)*n(i) - l(i)*(l(i) + 1)
         sc = z - d5*rh/rm
         s(i) = sc
         r3(i) = d0

         write(ouc,15) el(i),eii,az(i),sc,r3(i),r1,rm,rmm,
     &        ek(i),ekinp

 15      format(2x,a3,f20.12,f12.5,f9.4,4f11.6,4f12.5)
 214     format(2x,'el      E(nl)   Az(nl)   sigma  1/r**3  /',
     &                     '  1/r      r      r**2   I(nl)  /',
     &                     '  Ke')
 215     format(2x,a3,4d22.15,/5x,4d22.15,/5x,4d22.15)
         
      enddo

      if ( nl .eq. 0 ) go to 31

c     *****  add contribution from the 'l' integrals

      do i = 1,nl
         n1 = ncli(i)
         n2 = nclj(i)
         cc = cl(i)*wt(n1)*wt(n2)
         if (lq(i) .ne. 0) cc = cc*quadr(ilo(i),jlo(i),izero)**lq(i)
         cont = cc*(hl(ili(i),ilj(i)) - d2*z*quadr(ili(i),ilj(i),-ione))
         en = en + cont
      enddo

 31   epotl = ett - en
      ratio =-epotl/en
      call ecoul(ce)

      cedft=d0
      ekt=d0
      do i=1,nwf
         cedft=cedft+fk(i,i,0)
         ekt=ekt+ek(i)
      enddo

      xen=epotl+enpot-ce
      if (irel.eq.0) then
         write (ouc,26) ett,en,epotl,ce,xen,ce+cedft,xen-cedft,ratio
      else
         write (ouc,926) ett,en,epotl,ce,xen,ce+cedft,xen-cedft
      endif

 26   format(/4x,"total energy         = ",d24.14,
     &       /4x,"kinetic energy       = ",d24.14,
     &       /4x,"potential energy     = ",d24.14,
     &       /4x,"Coulomb energy       = ",d24.14,
     &       /4x,"exchange energy      = ",d24.14,
     &       /4x,"Coulomb energy (DFT) = ",d24.14,
     &       /4x,"exchange energy (DFT)= ",d24.14,
     &       /4x,"ratio                = ",d24.14)

 926  format(/4x,"total energy         = ",d24.14,
     &       /4x,"kinetic energy       = ",d24.14,
     &       /4x,"potential energy     = ",d24.14,
     &       /4x,"Coulomb energy       = ",d24.14,
     &       /4x,"exchange energy      = ",d24.14,
     &       /4x,"Coulomb energy (DFT) = ",d24.14,
     &       /4x,"exchange energy (DFT)= ",d24.14)


c FIXME
c      call exlda (exchen)
c      print *,'Exchange (LDA) energy: ',exchen

      if ( oud .eq. 0 ) return
      write (oud,126)
 126  format(/2x,27hvalues of f and g integrals       /)

c     *****  print tables of 'fk' and 'gk' integrals which were used in
c     *****  determining the energy

      do j = ib,nwf
         do i = 1,j
            kf = 0
            minv = 0
            do k = 1,5
               if (a(i,j,k) .eq. d0) go to 18
               iw(k) = minv
               out(k) = fk(i,j,minv)
               minv = minv + 2
               kf = kf + 1
            enddo

 18         if (kf .ne. 0) write(oud,19) (d,f,iw(k),el(i),
     1           el(j),out(k),k=1,kf)
 19         format( 2(2x,2a1,i1,1h(,a3,1h,,a3,4h ) =, f10.7,2x))
            minv = abs(l(i) - l(j))
            kf = 0
            do k = 1,5
               if (b(i,j,k) .eq. d0) go to 25
               iw(k) = minv
               out(k) = gk(i,j,minv)
               minv = minv + 2
               kf = kf + 1
            enddo
 25         if (kf .ne. 0) write(oud,19) (d,g,iw(k),el(i),
     1           el(j),out(k),k=1,kf)
         enddo
      enddo
            
      if (nr .eq. 0) go to 27

c     *****  print tables of 'rk' integrals

      write (oud,21)
21    format(//2x,21hvalues of r integrals  //)
      do i = 1,nr
         i1 = i1r(i)
         i2 = i2r(i)
         j1 = j1r(i)
         j2 = j2r(i)
         out(1) = rk(i1,i2,j1,j2,kr(i))
         write (oud,23) kr(i),el(i1),el(i2),el(j1),el(j2),out(1)
      enddo
 23   format(2x,1hr,i1,2h (,2a3,1h,, 2a3,4h ) =, f10.7 )
 27   if (nl .eq. 0) go to 13

c     *****  print tables of l'l' integrals

      write (oud,28)
 28   format(2x,21hvalues of l integrals //)
      do i = 1,nl
         i1 = ili(i)
         j1 = ilj(i)
         out(1) = hl(i1,j1)
         write(oud,30) el(i1),el(j1),out(1)
      enddo
 30   format(2x,2hl(,a3,1h,,a3,4h) = ,f16.7)

 13   write (oud,1)
 1    format(//3x,20hspin-orbit parameter,10x,
     1     20hspin-spin parameters/)

c     *****  compute and print spin-orbit and spin-spin parameters

      do k = 1,ncfg
         do i = 1,nwf
            qi = qc(i,k)
            li = l(i)
            if (qi .eq. 4*li+2 .or. li .eq. 0 .or. qi .eq. d0) go to 7
            if (li .eq. 4) go to 7
            sp = z*r3(i)*5.843574
            do j = 1,nwf
               if (l(j) .eq. 4) go to 4
               qj = qc(j,k)
               if (qj .eq. d0 .or. i .eq. j) go to 4
               lj = l(j) + 1
               c = qj
               sp = sp - d2*c*sm(i,j,0)
               if (qj .ne. 4*lj-2) go to 4
               do kk = 1,3
                  cc = cv(li,lj  ,kk)
                  if (cc .ne. d0) sp = sp - 
     1                 c*cc*v(i,j,(li+lj)+2*(kk-1-(li+lj)/2))
               enddo
               do kk = 1,4
                  cc = cn(li,lj  ,kk)
                  if (cc .ne. d0) sp = sp - 
     1                 c*cc*sn(i,j,(li+lj)-3+2*(kk -(li+lj)/2))
               enddo
 4             continue
            enddo

            c= qi
            if (c .eq. d1) go to 8
            ss(1) = sm(i,i,0)
            c = c + c - d3
            sp = sp - c*ss(1)
            go to (3,11,12), li
 11         ss(2) = sm(i,i,2)
            sp = sp + .857142857142857d0*ss(2)
            go to 3
 12         ss(2) = sm(i,i,2)
            ss(3) = sm(i,i,4)
            sp = sp + ss(2) + .4545454545454545d0*ss(3)
 3          write (oud,14) k,el(i),sp,(bl4,el(i),el(i),ss(ii),ii=1,li)
 14         format( 1x,i3,6h zeta(,a3,3h( =,f15.6,3x,a4,3hmo(,a3,1h,,a3,
     1           4h) = , f7.4,a4/34x,3hm2(,a3,1h ,a3,4h) = ,f7.4
     2           ,a4/34x,3hm4(,a3,1h,,a3,4h) = ,f7.4)
            go to 7
 8          write (oud,14) k,el(i),sp
 7          continue
         enddo
      enddo
      
      return
      end
