*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     The start subroutine computes the starting values used to solve a
*     ODE (see solve)
*
*****
      subroutine start(i,v0,p1x,p2x)
      implicit integer*4 (i-n)
      implicit real*8(a-h,o-z)

      include 'common.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      vv=v0+q0(i)
      dli=dlr(i)+d1
      zr=zrl(i)
      a=zr/dli
      b=(zr*zr+dli*(ed/d2+vv))/(dli*(d2*dli+d1))
      p1x=azd*r(1)**dli*(d1-a*r(1)+b*rr(1))/r2(1)
      p2x=azd*r(2)**dli*(d1-a*r(2)+b*rr(2))/r2(2)

      if (idbg(22).ne.0) then
         print *,'start'
         print *,'i,v0,q0(i)',i,v0,q0(i)
         stop
      endif
         
      return
      end
