*****
*****	Copyright (C) 1978 Charlotte Froese Fisher                                   
***** 	Copyright (C) 2012 Jacek Kobus                                               
*****
*
*     When first is .true. solve computes the potential and exchange
*     function and initializes variables for the i'th radial
*     equation. The vector p1 is the solution of the radial equation and
*     p2 the variation of the solution with respect to the energy
*     parameter e(i,i).
*
*****
c
      subroutine solve (i,first)
      implicit integer*4 (i-n)
      implicit real*8 (a-h,o-z)
      logical*1 first

      include 'common.inc'
      include 'common-ode.inc'
      include 'common-param.inc'
      include 'common-rel.inc'
      include 'common-wave.inc'

      dimension zerotmp(maxno),p1(maxno),xxsolve(maxno)
c      equivalence(zerotmp(1),xx(1)),(pde(1),p1(1))
      equivalence (pde(1),p1(1))

      fn = n(i)
      fl = l(i)
      v = yr(1)/r(1)
      c=d4*dlr(i)+d6
      cd = (fl+d5)*(fl+d5)

c     *****  if first is 'true', call potl and xch and set up arrays
      if (.not. first) go to 17

      call potl(i)
      call xch(i,ithree)

      fn = n(i)
      fl = l(i)
      v = yr(1)/r(1)
c      b4 = z*(fl+d1+d1/d3)/((fl+d1)*(fl+d2))
c      cn = (d2*z/fn)**(l(i) +1)
      c=d4*dlr(i)+d6
      cd = (fl+d5)*(fl+d5)
      xy = x(1)
      xp = x(2)
      ed = e(i,i)


      x1 = x(1)
      x2 = x(2)
      x3 = x(3)
      x4 = x(4)
      do j = 3,nd
         x5 = x(j+2)
         x(j) =ch*(-x5+24.d0*(x4+x2) + 194.d0*x3 - x1)/20.d0
         x1 = x2
         x2 = x3
         x3 = x4
         x4 = x5
      enddo
      x(no-1) = ch*(x4 + d10*x3 + x2)

      do j = 1,no
         yk(j)=-d2*(zvar(j)-yr(j))*r(j)+cd
      enddo 

c     *****  correct if the relativistic correction is present
c FIXME
      if(irel.ne.0) then
         do j=1,no
            zerotmp(j)=yk(j)
         enddo 

         call relpot(i)

c        Now  vxch(k)=(-z+yr(k))/r(k) + Vx(Slater)

         do j=1,no
            yk(j)=zerotmp(j)
         enddo 

C$$$         do j=1,no,50
C$$$            print *,j,yk(j),vrel(j)*rr(j)
C$$$         enddo 
         
         do j=1,no
            yk(j)=yk(j)+d2*vrel(j)*rr(j)
         enddo 

      endif

      x1 =    ch*p(i,1)*(yk(1)+ed*rr(1))
      x2 =    ch*p(i,2)*(yk(2)+ed*rr(2))
      x3 =    ch*p(i,3)*(yk(3)+ed*rr(3))
      x4 =    ch*p(i,4)*(yk(4)+ed*rr(4))
      do j = 3,nd
         x5 =    ch* p(i,j+2)*(yk(j+2)+ed*rr(j+2))
         x(j) = x(j) - (x5 -d4*(x2 + x4) + d6*x3 +x1)/20.d0
         x1 = x2
         x2 = x3
         x3 = x4
         x4 = x5
      enddo 
      rl=dlr(i)+2.5d0
      x(2) = r(2)**rl*(x(5)/r(5)**rl-d3*(x(4)/r(4)**rl -
     1     x(3)/r(3)**rl))

c     determine lower bound on the energy parameter

      do jj = 15,nd
	 j = no - jj
	 if (yk(j) .lt. d0) go to 63
      enddo 

      write (ouc,12) nd
12    format(10x,'potential function too small - 2r*(z-y)<(l+.5)**2)',
     &     5x,i4)
      stop

63    em = -yk(j)/rr(j)
      fm = em

c     *****   determine diagonal energy parameter

c FIXME
c     negative value of e(i,i) indicates that in the first iteration
c     this parameter is taken from the dump (comp. wavefn)

      if(e(i,i).lt.0.d0) then
         ed=-e(i,i)
         e(i,i)=ed
         goto 500
      endif
		    
      f1 = d0
      c11 = d0
      m = mmin(maxv(i),no-ione)
      do j = 2,m
         fnum = p(i,j+1) - p(i,j) - p(i,j) + p(i,j-1) 
     &        -ch*(       yk(j+1)*
     &        p(i,j+1) + d10*yk(j)*p(i,j) + yk(j-1)*p(i,j-1))-x(j)
         del1 = rr(j+1)*p(i,j+1) + d10*rr(j)*p(i,j) + rr(j-1)*p(i,j-1)
         f1 = f1 +p(i,j)*fnum
         c11 = c11 + p(i,j)*del1
      enddo
 2    ed = f1/(c11*ch)



500   continue

      if(ed .gt. em) go to 19

c     ***** error message and energy adjustment for an energy parameter
c     ***** too small for the range of the function

      write (ouc,24) ed
24    format(10x,5hed = ,f10.6,36h; adjusted to allowed minimum energy )
      ed = em
      if ( abs(fm - e(i,i)) .gt. 1.d-6 ) go to 19
      write (ouc,64) el(i)
64    format(//10x,14hiteration for ,a3,24h may be converging to a ,
     1   18hcontinuum function/10x,
     2   39hcheck that e(core)-e(total) is positive )

c     *****  check if upper bound is correct

19    if (d10*ed .lt. eu) go to 18
      eu = d10*ed
      fu = eu
18    azd = az(i)
17    do j=1,no
         yr(j) = (yk(j) + ed*rr(j))*ch
         zerotmp(j) = d0
      enddo

c     *****  search for the point at which yr becomes positive

      call search(nj,i)

c     *****  compute starting values from series expansion

      if (irel.ne.0) then 
         call start(i,v,p1x,p2x)
         hq(1)=p1x
         hq(2)=p2x
      else
c         b3 = (v + v + ed - (z/fn)**2)/c
         do j = 1,2
            b3 = (v + v + ed - (zvar(j)/fn)**2)/c
            b4 = zvar(j)*(fl+d1+d1/d3)/((fl+d1)*(fl+d2))
            cn = (d2*zvar(j)/fn)**dble(l(i) +1)
c FIXME zvar
c            hw  = hwf(n(i),l(i),z,r(j))/cn
            hw   = hwf(n(i),l(i),zvar(j),r(j))/cn
            hq(j)= azd*(hw + r(j)**dble(l(i)+3)*b3*(d1-r(j)*b4))/r2(j)
         enddo 
      endif

c     *****  obtain homogeneous solution

      call nmrvs(nj,delh,mh,hq,zerotmp)
      p1(1) = hq(1) + xy/c
      p1(2) = hq(2) + xp/c

c     *****  obtain particular solution

      call nmrvs(nj,del1,m1,p1,x)

c     *****  determine the energy adjustment required for a solution with
c     *****  given a0

      m = mmax(m1,mh)
      pnorm = d0
      do j = 1,m
         pnorm = pnorm + rr(j)*hq(j)*p1(j)
      enddo 
      y1 = p1(nj-1)
      y2 = p1(nj)
      y3 = p1(nj+1)
      delta = y2 - y1 + y2 - y3 +yr(nj-1)*y1 + d10*yr(nj)*y2
     1   + yr(nj+1)*y3 + x(nj)
      deltae = hq(nj)*delta/(h*h*pnorm)
      pp = -del1/delh

c     *****  match at the join for a solution of the differential equation

      do j = 1,no
	 p1(j)   = p1(j) + pp*hq(j)
      enddo 

c     ***** if the equations appear to be nearly singular, solve the
c     ***** variational equations

150   if (kk .ne. 2) return

149   x1 = p(i,1)*rr(1)
      x2 = p(i,2)*rr(2)
      p2(1) = x1/c
      p2(2) = x2/c
      do j = 3,no
         x3 = p(i,j)*rr(j)
         xxsolve(j-1) = (d10*x2 + x1 + x3)*ch
         x1 = x2
         x2 = x3
      enddo 
 
      call nmrvs(nj,del2,m2,p2,xxsolve)

      aa = -del2/delh
      m = mmax(m,m2)
      do j = 1,no
         p2(j) = p2(j) + aa*hq(j)
      enddo 

      a11 = quad(i,m,p2,p2)
      b11 = quad(i,m,p1,p2)
      c11 = quad(i,m,p1,p1) - d1
      disc = b11*b11 - a11*c11
      if ( disc .lt. d0 ) go to 70
      de1 = -(b11+sqrt(disc))/a11
      de2 = c11/a11/de1
      if( p1(3)+de1*p2(3) .lt. d0) de1 = de2
      go to 71

70    de1 = c11/a11

71    do j = 1,no
         p1(j) =p1(j) + de1*p2(j)
      enddo 
      pp = pp + de1*aa

      return
      end
